/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.session.redis;

import com.centit.framework.session.CentitSessionRepo;
import com.centit.framework.session.redis.CentitSessionRedisRepo;
import com.centit.support.security.SecurityOptUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;

@Configuration
@EnableRedisHttpSession(maxInactiveIntervalInSeconds=7200)
public class RedisSessionPersistenceConfig {
    private Logger logger = LoggerFactory.getLogger(RedisSessionPersistenceConfig.class);
    @Value(value="${session.redis.host:}")
    private String host;
    @Value(value="${session.redis.port:6379}")
    private Integer port;
    @Value(value="${session.redis.password:}")
    private String password;
    @Value(value="${session.redis.database:0}")
    private Integer database;

    @Bean
    public RedisConnectionFactory springSessionRedisConnectionFactory() {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.host, this.port.intValue());
        this.logger.debug("Redis Session\u670d\u52a1\u5668URL\uff1a" + this.host + ":" + this.port + "/" + this.database);
        System.out.println("Redis Session\u670d\u52a1\u5668URL\uff1a" + this.host + ":" + this.port + "/" + this.database);
        configuration.setDatabase(this.database.intValue());
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            configuration.setPassword(RedisPassword.of((String)SecurityOptUtils.decodeSecurityString((String)this.password)));
        }
        return new LettuceConnectionFactory(configuration);
    }

    @Bean
    public SessionRegistry sessionRegistry(@Autowired RedisIndexedSessionRepository sessionRepository) {
        SpringSessionBackedSessionRegistry sessionRegistry = new SpringSessionBackedSessionRegistry((FindByIndexNameSessionRepository)sessionRepository);
        return sessionRegistry;
    }

    @Bean
    public CentitSessionRepo centitSessionRepo(@Autowired RedisIndexedSessionRepository sessionRepository) {
        return new CentitSessionRedisRepo(sessionRepository);
    }
}

