/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.web.context.ContextLoaderListener;

public class DataPowerFilter {
    private Map<String, Object> sourceData;
    private static Map<String, Map<String, String>> hqlMetaData;

    public void setSourceDatas(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
    }

    public void setSourceFromJson(JSONObject sourceJson) {
        this.sourceData = sourceJson;
    }

    public void addSourceData(String name, Object data) {
        if (data == null) {
            return;
        }
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        this.sourceData.put(name, data);
    }

    public void addSourceData(Object data) {
        if (data == null) {
            return;
        }
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        this.sourceData.put(data.getClass().getSimpleName(), data);
    }

    public void addSourceDatas(Collection<Object> sourceData) {
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        for (Object obj : sourceData) {
            if (obj == null) continue;
            this.sourceData.put(obj.getClass().getSimpleName(), obj);
        }
    }

    public void addSourceDatas(Map<String, Object> paramMap) {
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        this.sourceData.putAll(paramMap);
    }

    public void addSourceDatas(Object[] sourceData) {
        if (this.sourceData == null) {
            this.sourceData = new HashMap<String, Object>();
        }
        for (Object obj : sourceData) {
            if (obj == null) continue;
            this.sourceData.put(obj.getClass().getSimpleName(), obj);
        }
    }

    public void setSourceDatas(Collection<Object> sourceData) {
        this.sourceData = new HashMap<String, Object>();
        for (Object obj : sourceData) {
            this.sourceData.put(obj.getClass().getSimpleName(), obj);
        }
    }

    public void setSourceDatas(Object[] sourceData) {
        this.sourceData = new HashMap<String, Object>();
        for (Object obj : sourceData) {
            this.sourceData.put(obj.getClass().getSimpleName(), obj);
        }
    }

    private Object attainExpressionValue(String expression) {
        return ReflectionOpt.attainExpressionValue(this.sourceData, (String)expression);
    }

    private Object getObjectFieldValue(Object obj, String valueField) {
        if (obj == null || valueField == null || "".equals(valueField)) {
            return null;
        }
        String[] fs = valueField.split("\\.");
        Object retObj = obj;
        for (int i = 0; i < fs.length; ++i) {
            if (retObj instanceof Map) {
                Map objMap = (Map)retObj;
                retObj = objMap.get(fs[i]);
            } else {
                retObj = ReflectionOpt.getFieldValue((Object)retObj, (String)fs[i]);
            }
            if (retObj != null) continue;
            return null;
        }
        return retObj;
    }

    public static Map<String, Map<String, String>> getHqlMetaData() {
        if (hqlMetaData == null) {
            hqlMetaData = new HashMap<String, Map<String, String>>();
            SessionFactory sessionFactory = (SessionFactory)ContextLoaderListener.getCurrentWebApplicationContext().getBean("sessionFactory", SessionFactory.class);
            Map cm = sessionFactory.getAllClassMetadata();
            for (Map.Entry ent : cm.entrySet()) {
                Field[] objFields;
                HashMap<String, String> metaData = new HashMap<String, String>();
                String className = (String)ent.getKey();
                String shortClassName = className.substring(className.lastIndexOf(".") + 1);
                Class poClass = ((ClassMetadata)ent.getValue()).getMappedClass();
                Table tableName = poClass.getAnnotation(Table.class);
                metaData.put(".talbeName", tableName.name());
                for (Field field : objFields = poClass.getDeclaredFields()) {
                    Field[] idFields;
                    if (field.isAnnotationPresent(Column.class)) {
                        Column colMeta = field.getAnnotation(Column.class);
                        metaData.put(field.getName(), colMeta.name());
                        continue;
                    }
                    if (!field.isAnnotationPresent(EmbeddedId.class)) continue;
                    String sId = field.getName() + ".";
                    Class<?> idClass = field.getType();
                    for (Field idfield : idFields = idClass.getDeclaredFields()) {
                        if (!idfield.isAnnotationPresent(Column.class)) continue;
                        Column colMeta = idfield.getAnnotation(Column.class);
                        metaData.put(sId + idfield.getName(), colMeta.name());
                    }
                }
                Class supClass = poClass.getSuperclass();
                while (!supClass.equals(Object.class)) {
                    Field[] supFields;
                    for (Field supfield : supFields = supClass.getDeclaredFields()) {
                        if (!supfield.isAnnotationPresent(Column.class)) continue;
                        Column colMeta = supfield.getAnnotation(Column.class);
                        metaData.put(supfield.getName(), colMeta.name());
                    }
                    supClass = supClass.getSuperclass();
                }
                hqlMetaData.put(shortClassName, metaData);
            }
        }
        return hqlMetaData;
    }

    public QueryAndNamedParams makeHQL(Class<?> poClass, Collection<String> filters, boolean jointSql) {
        String shortClassName = poClass.getSimpleName();
        return this.makeHQL(shortClassName, filters, jointSql);
    }

    public QueryAndNamedParams makeHQL(String shortClassName, Collection<String> filters, boolean jointSql) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        HashMap<String, String> tables = new HashMap<String, String>();
        tables.put(shortClassName, "");
        DataPowerFilterTranslater translater = new DataPowerFilterTranslater(false, jointSql, this);
        translater.setTableAlias(tables);
        StringBuilder hql = new StringBuilder("From ").append(shortClassName).append(" where");
        boolean hasFilter = false;
        if (filters != null) {
            for (String filter : filters) {
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter((String)filter, (QueryUtils.IFilterTranslater)translater);
                if (hqlPiece == null) continue;
                hqlAndParams.addAllParams(hqlPiece.getParams());
                if (hasFilter) {
                    hql.append(" or");
                } else {
                    hql.append(" (");
                }
                hql.append(" ").append(hqlPiece.getHql());
                hasFilter = true;
            }
        }
        if (hasFilter) {
            hql.append(" )");
        } else {
            hql.append(" 1=1");
        }
        hqlAndParams.setHql(hql.toString());
        return hqlAndParams;
    }

    public QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, boolean toSql, boolean jointSql, boolean isUnion) {
        return QueryUtils.translateQuery((String)queryStatement, filters, (boolean)isUnion, (QueryUtils.IFilterTranslater)new DataPowerFilterTranslater(toSql, jointSql, this));
    }

    public QueryAndNamedParams translateHqlQuery(String queryStatement, Collection<String> filters) {
        return this.translateQuery(queryStatement, filters, false, false, true);
    }

    public QueryAndNamedParams translateSqlQuery(String queryStatement, Collection<String> filters) {
        return this.translateQuery(queryStatement, filters, true, false, true);
    }

    public QueryAndNamedParams translateSqlFilterQuery(String queryStatement, Collection<String> filters) {
        return this.translateQuery(queryStatement, filters, true, false, false);
    }

    public int checkObjectFilter(Object obj, String filter) {
        String poClassName = obj.getClass().getSimpleName();
        Lexer varMorp = new Lexer();
        varMorp.setFormula(filter);
        StringBuilder checkStatement = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        while (sWord != null && !sWord.equals("")) {
            int curPos;
            if (sWord.equals("[")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    checkStatement.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekTo(']');
                prePos = varMorp.getCurrPos();
                String columnDesc = filter.substring(curPos, prePos - 1).trim();
                int n = columnDesc.indexOf(46);
                if (n < 0) {
                    return 0;
                }
                String tempClassName = columnDesc.substring(0, n);
                if (!poClassName.equals(tempClassName)) {
                    return 0;
                }
                Object fieldValue = this.getObjectFieldValue(obj, columnDesc.substring(n + 1));
                checkStatement.append(QueryUtils.buildObjectStringForQuery((Object)fieldValue));
            } else if (sWord.equals("{")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    checkStatement.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekTo('}');
                prePos = varMorp.getCurrPos();
                String valueDesc = filter.substring(curPos, prePos - 1).trim();
                Object fieldValue = this.attainExpressionValue(valueDesc);
                checkStatement.append(QueryUtils.buildObjectStringForQuery((Object)fieldValue));
            }
            sWord = varMorp.getAWord();
        }
        checkStatement.append(filter.substring(prePos));
        return BooleanBaseOpt.castObjectToBoolean((Object)VariableFormula.calculate((String)checkStatement.toString())) != false ? 1 : -1;
    }

    public boolean checkObject(Object obj, Collection<String> filters) {
        if (filters == null) {
            return true;
        }
        int nFalse = 0;
        for (String filter : filters) {
            int nRes = this.checkObjectFilter(obj, filter);
            if (nRes == 1) {
                return true;
            }
            if (nRes != -1) continue;
            ++nFalse;
        }
        return nFalse <= 0;
    }

    private static class DataPowerFilterTranslater
    implements QueryUtils.IFilterTranslater {
        private Map<String, String> tableAlias = null;
        private boolean toSql;
        private boolean jointSql;
        private DataPowerFilter dataPowerFilter;

        public DataPowerFilterTranslater(boolean toSql, boolean jointSql, DataPowerFilter dataPowerFilter) {
            this.toSql = toSql;
            this.jointSql = jointSql;
            this.dataPowerFilter = dataPowerFilter;
        }

        public void setTableAlias(Map<String, String> tableAlias) {
            this.tableAlias = tableAlias;
        }

        public String translateColumn(String columnDesc) {
            if (this.tableAlias == null || columnDesc == null || this.tableAlias.size() == 0) {
                return null;
            }
            int n = columnDesc.indexOf(46);
            if (n < 0) {
                return this.tableAlias.get(columnDesc);
            }
            String poClassName = columnDesc.substring(0, n);
            String alias = this.tableAlias.get(poClassName);
            if (alias == null) {
                return null;
            }
            if (this.toSql) {
                Map<String, String> poClassMate = DataPowerFilter.getHqlMetaData().get(poClassName);
                if (poClassMate == null) {
                    return null;
                }
                String fieldName = poClassMate.get(columnDesc.substring(n + 1));
                return "".equals(alias) ? fieldName : alias + '.' + fieldName;
            }
            return "".equals(alias) ? columnDesc.substring(n + 1) : alias + '.' + columnDesc.substring(n + 1);
        }

        public LeftRightPair<String, Object> translateParam(String paramName) {
            Object obj = this.dataPowerFilter.attainExpressionValue(paramName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
                return null;
            }
            if (this.jointSql) {
                return new LeftRightPair((Object)QueryUtils.buildObjectStringForQuery((Object)obj), null);
            }
            return new LeftRightPair((Object)paramName, obj);
        }

        public String getVarValue(String varName) {
            Object res = this.dataPowerFilter.attainExpressionValue(varName);
            if (res == null) {
                return "\"\"";
            }
            return StringRegularOpt.quotedString((String)StringBaseOpt.objectToString((Object)res));
        }

        public String getLabelValue(String labelName) {
            return this.getVarValue(labelName);
        }
    }
}

