/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.service;

import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.service.BaseEntityManager;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.support.algorithm.ReflectionOpt;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseEntityManagerImpl<T extends Serializable, PK extends Serializable, D extends BaseDaoImpl<T, PK>>
implements BaseEntityManager<T, PK> {
    protected D baseDao = null;
    protected Log logger = LogFactory.getLog(BaseEntityManagerImpl.class);
    protected boolean logDebug = this.logger.isDebugEnabled();

    protected void setBaseDao(D baseDao) {
        this.baseDao = baseDao;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteObject(T o) {
        ((BaseDaoImpl)this.baseDao).deleteObject(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteObjectById(PK id) {
        ((BaseDaoImpl)this.baseDao).deleteObjectById(id);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveObject(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Serializable saveNewObject(T o) {
        return ((BaseDaoImpl)this.baseDao).saveNewObject(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void updateObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveObject(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void mergeObject(T o) {
        ((BaseDaoImpl)this.baseDao).mergeObject(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void updateObjectCheckTimestamp(T o) {
        ((BaseDaoImpl)this.baseDao).updateObjectCheckTimestamp(o);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectById(PK id) {
        return ((BaseDaoImpl)this.baseDao).getObjectById(id);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectByProperty(String propertyName, Object propertyValue) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperty(propertyName, propertyValue);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public T getObjectByProperties(Map<String, Object> properties) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperties(properties);
    }

    public void copyObjectNotNullProperty(T des, T sou) {
        ReflectionOpt.invokeBinaryOpt(des, (String)"copyNotNullProperty", sou);
    }

    public void clearObjectProperties(T des) {
        ReflectionOpt.invokeNoParamFunc(des, (String)"clearProperties");
    }

    public void copyObject(T des, T sou) {
        ReflectionOpt.invokeBinaryOpt(des, (String)"copy", sou);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects() {
        return ((BaseDaoImpl)this.baseDao).listObjects();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listValidObjects() {
        return ((BaseDaoImpl)this.baseDao).listValidObjects();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(String shql, Map<String, Object> filterMap) {
        return ((BaseDaoImpl)this.baseDao).listObjects(shql, filterMap);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(Map<String, Object> filterMap) {
        return ((BaseDaoImpl)this.baseDao).listObjects(filterMap, null);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(String shql, Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjects(shql, filterMap, pageDesc);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<T> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjects(filterMap, pageDesc);
    }
}

