/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.common;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class SysParametersUtils {
    private static final Logger logger = LoggerFactory.getLogger(SysParametersUtils.class);
    private static Properties prop;
    private static String APP_HOME;
    private static String APPLICATION_CONFIG_FILE_NAME;

    public static String getAppHome() {
        return SysParametersUtils.getStringValue(APP_HOME);
    }

    public static String getTempHome() {
        return SysParametersUtils.getAppHome() + "/temp";
    }

    public static String getUploadTempHome() {
        return SysParametersUtils.getTempHome();
    }

    public static String getConfigHome() {
        return SysParametersUtils.getAppHome() + "/config";
    }

    public static String getLogHome() {
        return SysParametersUtils.getAppHome() + "/logs";
    }

    public static String getUploadHome() {
        return SysParametersUtils.getAppHome() + "/upload";
    }

    public static String getIndexHome() {
        return SysParametersUtils.getAppHome() + "/index";
    }

    public static String getPublicFileHome() {
        return SysParametersUtils.getAppHome() + "/publicfile";
    }

    public static String getStringValue(String key) {
        return SysParametersUtils.getStringValue(key, null);
    }

    public static String getStringValue(String key, String defaultValue) {
        Properties properties = SysParametersUtils.loadProperties();
        String value = properties.getProperty(key, defaultValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}");
        return helper.replacePlaceholders(value, properties);
    }

    public static int getIntValue(String key) {
        return Integer.parseInt(SysParametersUtils.loadProperties().getProperty(key));
    }

    public static int getIntValue(String key, int defaultValue) {
        String s = SysParametersUtils.loadProperties().getProperty(key);
        if (StringRegularOpt.isNumber((String)s)) {
            return NumberBaseOpt.parseInteger((String)s, (Integer)defaultValue);
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(SysParametersUtils.getStringValue(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String sValue = SysParametersUtils.getStringValue(key);
        return StringUtils.isNotBlank((CharSequence)sValue) ? Boolean.parseBoolean(sValue) : defaultValue;
    }

    public static Properties loadProperties() {
        return SysParametersUtils.loadProperties(false);
    }

    public static Properties loadProperties(boolean forceReload) {
        block29: {
            if (forceReload || null == prop) {
                prop = new Properties();
                try (InputStream resource = SysParametersUtils.class.getResourceAsStream(APPLICATION_CONFIG_FILE_NAME);){
                    if (resource == null) {
                        try (InputStream resource2 = ClassLoader.getSystemResourceAsStream(APPLICATION_CONFIG_FILE_NAME);){
                            if (resource2 != null) {
                                prop.load(resource2);
                            }
                            break block29;
                        }
                    }
                    prop.load(resource);
                }
                catch (IOException e) {
                    logger.error("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u51fa\u9519\uff01", (Throwable)e);
                }
            }
        }
        return prop;
    }

    static {
        APP_HOME = "app.home";
        APPLICATION_CONFIG_FILE_NAME = "/system.properties";
    }
}

