/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.redis.config;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.security.SecurityOptUtils;
import io.lettuce.core.RedisClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class RedisClientConfig
implements EnvironmentAware {
    private Logger logger = LoggerFactory.getLogger(RedisClientConfig.class);
    protected Environment env;

    public void setEnvironment(@Autowired Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean
    public RedisClient redisClient() {
        String host = this.env.getProperty("redis.default.host");
        Integer port = NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("redis.default.port"), (Integer)6379);
        String password = this.env.getProperty("redis.default.password");
        Integer database = NumberBaseOpt.castObjectToInteger((Object)this.env.getProperty("redis.default.database"), (Integer)0);
        StringBuilder redisUri = new StringBuilder("redis://");
        if (StringUtils.isNotBlank((CharSequence)password)) {
            redisUri.append(SecurityOptUtils.decodeSecurityString((String)password)).append("@");
        }
        redisUri.append(host).append(":").append(port).append("/").append(database);
        this.logger.info("Redis\u6570\u636e\u7f13\u5b58\u670d\u52a1\u5668:{}", (Object)redisUri.toString());
        return RedisClient.create((String)redisUri.toString());
    }
}

