/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.JsonDaoExecuteWork;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectWork
implements JsonObjectDao {
    protected static Logger logger = LoggerFactory.getLogger(JsonObjectWork.class);
    private TableInfo tableInfo;
    private BaseDaoImpl<?, ?> baseDao;
    private JsonObjectDao currentDao = null;

    public JsonObjectWork() {
    }

    public JsonObjectWork(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectWork(BaseDaoImpl<?, ?> baseDao, TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public JsonObjectDao getCurrentDao() throws SQLException {
        if (this.currentDao == null) {
            this.currentDao = GeneralJsonObjectDao.createJsonObjectDao((Connection)this.baseDao.getConnection(), (TableInfo)this.tableInfo);
        }
        return this.currentDao;
    }

    public <T> T executeRealWork(JsonDaoExecuteWork<T> realWork) throws SQLException, IOException {
        Connection conn = this.baseDao.getConnection();
        try {
            T relRet;
            GeneralJsonObjectDao currentDao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)this.tableInfo);
            T t = relRet = realWork.execute((JsonObjectDao)currentDao);
            return t;
        }
        catch (SQLException e) {
            logger.error("error code :" + e.getSQLState() + e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.baseDao.releaseConnection(conn);
        }
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.getObjectById(keyValue));
    }

    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.getObjectByProperties(properties));
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.listObjectsByProperties(properties));
    }

    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.listObjectsByProperties(properties, startPos, maxSize));
    }

    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.fetchObjectsCount(properties));
    }

    public int saveNewObject(Map<String, Object> object) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.saveNewObject(object));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public Map<String, Object> saveNewObjectAndFetchGeneratedKeys(Map<String, Object> object) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.saveNewObjectAndFetchGeneratedKeys(object));
    }

    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.updateObject(fields, object));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int updateObject(Map<String, Object> object) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.updateObject(object));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.mergeObject(fields, object));
    }

    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.mergeObject(object));
    }

    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.updateObjectsByProperties(fieldValues, properties));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.updateObjectsByProperties(fields, fieldValues, properties));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int deleteObjectById(Object keyValue) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.deleteObjectById(keyValue));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.deleteObjectsByProperties(properties));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int insertObjectsAsTabulation(List<Map<String, Object>> objects) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.insertObjectsAsTabulation(objects));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int deleteObjects(List<Object> objects) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.deleteObjects(objects));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.deleteObjectsAsTabulation(propertyName, propertyValue));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.deleteObjectsAsTabulation(properties));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, List<Map<String, Object>> dbObjects) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.replaceObjectsAsTabulation(newObjects, dbObjects));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.replaceObjectsAsTabulation(newObjects, propertyName, propertyValue));
    }

    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, Map<String, Object> properties) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.replaceObjectsAsTabulation(newObjects, properties));
    }

    public Long getSequenceNextValue(String sequenceName) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.getSequenceNextValue(sequenceName));
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsBySql(sSql, values));
    }

    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsBySql(sSql, values, pageNo, pageSize));
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsByNamedSql(sSql, values));
    }

    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsByNamedSql(sSql, values, pageNo, pageSize));
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsAsJSON(sSql, values, fieldnames));
    }

    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsAsJSON(sSql, values, fieldnames, pageNo, pageSize));
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames));
    }

    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        return this.executeRealWork(dao -> dao.findObjectsByNamedSqlAsJSON(sSql, values, fieldnames, pageNo, pageSize));
    }

    public boolean doExecuteSql(String sSql) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.doExecuteSql(sSql));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.doExecuteSql(sSql, values));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        try {
            return this.executeRealWork(dao -> dao.doExecuteNamedSql(sSql, values));
        }
        catch (IOException e) {
            logger.error("error code :" + e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }
}

