/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.flyway.plugin;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTableImpl;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;

public class MetaDataExtTableImpl
extends MetaDataTableImpl {
    private final Table table;
    private static final Log LOG = LogFactory.getLog(MetaDataExtTableImpl.class);
    private final DbSupport dbSupport;
    private final JdbcTemplate jdbcTemplate;
    private String installedBy;

    public MetaDataExtTableImpl(DbSupport dbSupport, Table table, String installedBy) {
        super(dbSupport, table, installedBy);
        this.table = table;
        this.dbSupport = dbSupport;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.installedBy = installedBy == null ? dbSupport.getCurrentUserFunction() : "'" + installedBy + "'";
    }

    public void createIfNotExists() {
        int retries = 0;
        while (!this.table.exists()) {
            if (retries == 0) {
                LOG.info("Creating Metadata table: " + this.table);
            }
            try {
                String resourceName = "com/centit/framework/flyway/plugin/" + this.dbSupport.getDbName() + "/createMetaDataTable.sql";
                String source = new ClassPathResource(resourceName, ((Object)((Object)this)).getClass().getClassLoader()).loadAsString("UTF-8");
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("schema", this.table.getSchema().getName());
                placeholders.put("table", this.table.getName());
                String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
                SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
                sqlScript.execute(this.jdbcTemplate);
                LOG.debug("Metadata table " + this.table + " created.");
            }
            catch (FlywayException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Metadata table creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private int calculateInstalledRank() throws SQLException {
        int currentMax = this.jdbcTemplate.queryForInt("SELECT MAX(" + this.dbSupport.quote(new String[]{"installed_rank"}) + ") FROM " + this.table, new String[0]);
        return currentMax + 1;
    }

    public <T> T lock(Callable<T> callable) {
        this.createIfNotExists();
        return (T)this.dbSupport.lock(this.table, callable);
    }

    public void addAppliedMigration(AppliedMigration appliedMigration) {
        this.dbSupport.changeCurrentSchemaTo(this.table.getSchema());
        this.createIfNotExists();
        MigrationVersion version = appliedMigration.getVersion();
        try {
            String versionStr = version == null ? null : version.toString();
            String resourceName = "com/centit/framework/flyway/plugin/" + this.dbSupport.getDbName() + "/updateMetaDataTable.sql";
            ClassPathResource classPathResource = new ClassPathResource(resourceName, ((Object)((Object)this)).getClass().getClassLoader());
            int installedRank = this.calculateInstalledRank();
            if (classPathResource.exists()) {
                String source = classPathResource.loadAsString("UTF-8");
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("schema", this.table.getSchema().getName());
                placeholders.put("table", this.table.getName());
                placeholders.put("installed_rank_val", String.valueOf(installedRank));
                placeholders.put("version_val", versionStr);
                placeholders.put("description_val", appliedMigration.getDescription());
                placeholders.put("type_val", appliedMigration.getType().name());
                placeholders.put("script_val", appliedMigration.getScript());
                placeholders.put("checksum_val", String.valueOf(appliedMigration.getChecksum()));
                placeholders.put("installed_by_val", this.installedBy);
                placeholders.put("execution_time_val", String.valueOf((long)appliedMigration.getExecutionTime() * 1000L));
                placeholders.put("success_val", String.valueOf(appliedMigration.isSuccess()));
                String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
                SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
                sqlScript.execute(this.jdbcTemplate);
            } else {
                this.jdbcTemplate.update("INSERT INTO " + this.table + " (" + this.dbSupport.quote(new String[]{"installed_rank"}) + "," + this.dbSupport.quote(new String[]{"version"}) + "," + this.dbSupport.quote(new String[]{"description"}) + "," + this.dbSupport.quote(new String[]{"type"}) + "," + this.dbSupport.quote(new String[]{"script"}) + "," + this.dbSupport.quote(new String[]{"checksum"}) + "," + this.dbSupport.quote(new String[]{"installed_by"}) + "," + this.dbSupport.quote(new String[]{"execution_time"}) + "," + this.dbSupport.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, " + this.installedBy + ", ?, ?)", new Object[]{installedRank, versionStr, appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess()});
            }
            LOG.debug("MetaData table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to insert row for version '" + version + "' in metadata table " + this.table, e);
        }
    }
}

