/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenant.controller;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.po.UserInfo;
import com.centit.support.security.AESSecurityUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/vateCode"})
@Api(value="\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3", tags={"\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3"})
public class VateCodeController
extends BaseController {
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private UserInfoDao userInfoDao;

    @ApiOperation(value="\u9a8c\u8bc1\u552f\u4e00\u6027", notes="\u9a8c\u8bc1\u552f\u4e00\u6027")
    @RequestMapping(value={"/checkOnly"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkOnly(@RequestParam(value="loginname") String loginname, HttpServletRequest request) throws Exception {
        UserInfo userInfo = new UserInfo();
        String msg = "";
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(loginname);
        if (loginname.indexOf(64) > 0) {
            msg = "\u90ae\u4ef6";
            userInfo = this.userInfoDao.getUserByRegEmail(loginname);
        } else if (loginname.length() == 11 && isNum.matches()) {
            msg = "\u624b\u673a\u53f7";
            userInfo = this.userInfoDao.getUserByRegCellPhone(loginname);
        } else {
            msg = "\u8d26\u53f7";
            userInfo = this.userInfoDao.getUserByLoginName(loginname);
        }
        if (userInfo != null) {
            return ResponseData.makeErrorMessage((String)("\u6b64" + msg + "\u5df2\u88ab\u4f7f\u7528\uff01"));
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6Email\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6Email\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getEmailCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData getEmailCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="email") String email, HttpServletRequest request) {
        UserInfo userInfo = this.userInfoDao.getUserByRegEmail(email);
        if (userInfo != null) {
            return ResponseData.makeErrorMessage((String)"\u6b64\u90ae\u7bb1\u5df2\u88ab\u4f7f\u7528\uff01");
        }
        String key = userCode;
        if (userCode == null) {
            key = email;
        }
        return this.sendEmail(email, key, request);
    }

    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getPhoneCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public SendSmsResponse getPhoneCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="phone") String phone, HttpServletRequest request) throws Exception {
        UserInfo userInfo;
        if (phone != null && !phone.equals("") && (userInfo = this.userInfoDao.getUserByRegCellPhone(phone)) != null) {
            throw new Exception("\u6b64\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528\uff01");
        }
        String key = userCode;
        if (userCode == null) {
            key = phone;
        }
        return this.sendPhone(phone, key, userCode, request);
    }

    @ApiOperation(value="\u6821\u9a8c\u548c\u66f4\u65b0", notes="\u6821\u9a8c\u548c\u66f4\u65b0")
    @RequestMapping(value={"/checkCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            if (code == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
            }
            JSONObject json = JSONObject.parseObject((String)(request.getSession().getAttribute(key) + ""));
            if (json == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u672a\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
            }
            String verifyCode = json.getString("verifyCode");
            Long createTime = json.getLong("createTime");
            String email = json.getString("email");
            String phone = json.getString("phone");
            if (!verifyCode.equals(code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
            if (System.currentTimeMillis() - createTime > 300000L) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            }
            UserInfo user = this.userInfoDao.getUserByCode(userCode);
            if (user != null) {
                if (email != null && !email.equals("")) {
                    user.setRegEmail(email);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u90ae\u7bb1", (Object)userCode);
                } else if (phone != null && !phone.equals("")) {
                    user.setRegCellPhone(phone);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u624b\u673a", (Object)userCode);
                }
                this.userInfoDao.updateUser(user);
            }
            request.getSession().removeAttribute(key);
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)", notes="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)")
    @RequestMapping(value={"/findPwd"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData findPwd(@RequestParam(value="loginname") String loginname, HttpServletRequest request) throws Exception {
        try {
            if (loginname.indexOf(64) > 0) {
                this.sendEmail(loginname, loginname, request);
            } else {
                this.sendPhone(loginname, loginname, "", request);
            }
            return ResponseData.successResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f", notes="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/checkCodeUser"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCodeUser(@RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            if (code == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
            }
            JSONObject json = JSONObject.parseObject((String)(request.getSession().getAttribute(key) + ""));
            if (json == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u672a\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
            }
            String verifyCode = json.getString("verifyCode");
            Long createTime = json.getLong("createTime");
            String email = json.getString("email");
            String phone = json.getString("phone");
            if (!verifyCode.equals(code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
            if (System.currentTimeMillis() - createTime > 300000L) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            }
            UserInfo userInfo = new UserInfo();
            if (email != null && !email.equals("")) {
                userInfo = this.userInfoDao.getUserByRegEmail(email);
            } else if (phone != null && !phone.equals("")) {
                userInfo = this.userInfoDao.getUserByRegCellPhone(phone);
            }
            request.getSession().removeAttribute(key);
            return ResponseData.makeResponseData((Object)userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    public ResponseData sendEmail(String email, String key, HttpServletRequest request) {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        String message = "\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a:" + verifyCode + "\uff0c\u8be5\u7801\u6709\u6548\u671f\u4e3a5\u5206\u949f\uff0c\u8be5\u7801\u53ea\u80fd\u4f7f\u7528\u4e00\u6b21!";
        ArrayList<String> sendMessageUser = new ArrayList<String>();
        sendMessageUser.add(email);
        JSONObject json = new JSONObject();
        json.put("email", (Object)email);
        json.put("verifyCode", (Object)verifyCode);
        json.put("createTime", (Object)System.currentTimeMillis());
        request.getSession().setAttribute(key, (Object)json);
        return this.notificationCenter.sendMessage("system", sendMessageUser, NoticeMessage.create().operation("email").method("post").subject("\u60a8\u6709\u65b0\u90ae\u4ef6").content(message));
    }

    public SendSmsResponse sendPhone(String phone, String key, String userCode, HttpServletRequest request) throws Exception {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("code", (Object)verifyCode);
        UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
        if (userInfo == null) {
            jSONObject.put("product", (Object)"\u7528\u6237");
        } else {
            jSONObject.put("product", (Object)("\u7528\u6237" + userInfo.getUserName()));
        }
        Client client = VateCodeController.createClient();
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName("\u8eab\u4efd\u9a8c\u8bc1").setTemplateCode("SMS_65920066").setPhoneNumbers(phone).setTemplateParam(jSONObject.toString());
        JSONObject json = new JSONObject();
        json.put("phone", (Object)phone);
        json.put("verifyCode", (Object)verifyCode);
        json.put("createTime", (Object)System.currentTimeMillis());
        request.getSession().setAttribute(key, (Object)json);
        return client.sendSms(sendSmsRequest);
    }

    public static Client createClient() throws Exception {
        String accessKeyId = "+GrP3D07U/aR2WDtm9iTSUeJ0F00X0f75Byebbcw8fc=";
        String accessKeySecret = "gqdjhi7JEasb2uiOW/riueAXA4vvOxsgYfmdRbAqwIU=";
        Config config = new Config().setAccessKeyId(AESSecurityUtils.decryptBase64String((String)accessKeyId, (String)"0123456789abcdefghijklmnopqrstuvwxyzABCDEF")).setAccessKeySecret(AESSecurityUtils.decryptBase64String((String)accessKeySecret, (String)"0123456789abcdefghijklmnopqrstuvwxyzABCDEF"));
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }
}

