/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenan.service.impl;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.tenan.dao.TenantInfoDao;
import com.centit.framework.tenan.po.TenantInfo;
import com.centit.framework.tenan.service.TenantPowerManage;
import com.centit.product.dao.WorkGroupDao;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantPowerManageImpl
implements TenantPowerManage {
    protected Logger logger = LoggerFactory.getLogger(TenantPowerManage.class);
    @Autowired
    private TenantInfoDao tenantInfoDao;
    @Autowired
    private WorkGroupDao workGroupDao;
    @Autowired
    private UserUnitDao userUnitDao;
    @Autowired
    private UnitInfoDao unitInfoDao;

    @Override
    public boolean userIsTenantOwner(String userCode, String topUnit) {
        return this.tenantInfoDao.userIsOwner(topUnit, userCode);
    }

    @Override
    public boolean userIsTenantOwner(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantOwner(userCode, topUnit);
    }

    @Override
    public boolean userIsTenantAdmin(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit, "userCode", userCode, "roleCode", "ZHGLY"});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public String userTenantRole(String topUnit) {
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(302, "topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.userIsTenantOwner(topUnit)) {
            return "OWN";
        }
        if (this.userIsTenantAdmin(topUnit)) {
            return "ZHGLY";
        }
        if (this.userIsTenantMember(topUnit)) {
            return "ZHZY";
        }
        return "";
    }

    @Override
    public boolean userIsTenantAdmin(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantAdmin(userCode, topUnit);
    }

    @Override
    public boolean userIsTenantMember(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "topUnit", topUnit});
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listObjects(filterMap));
    }

    @Override
    public boolean userIsTenantMember(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantMember(userCode, topUnit);
    }

    @Override
    public boolean userIsApplicationAdmin(String userCode, String osId) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode, "roleCode", "OSZZ"});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public boolean userIsApplicationAdmin(String osId) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsApplicationAdmin(userCode, osId);
    }

    @Override
    public boolean userIsApplicationMember(String userCode, String osId) throws ObjectException {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public boolean userIsApplicationMember(String osId) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsApplicationMember(userCode, osId);
    }

    @Override
    public boolean userIsSystemMember(String userCode) {
        return this.userIsTenantMember(userCode, "system");
    }

    @Override
    public boolean userIsSystemMember() {
        return this.userIsTenantMember("system");
    }

    @Override
    public boolean userIsSystemAdmin(String userCode) {
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listUserUnitsByUserCode("system", userCode));
    }

    @Override
    public boolean userIsSystemAdmin() {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listUserUnitsByUserCode("system", userCode));
    }

    @Override
    public boolean userNumberLimitIsOver(String topUnit) {
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(topUnit);
        if (null == tenantInfo || null == tenantInfo.getUserNumberLimit()) {
            return true;
        }
        return this.userUnitDao.countUserByTopUnit(topUnit) >= tenantInfo.getUserNumberLimit();
    }

    @Override
    public boolean unitNumberLimitIsOver(String topUnit) {
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(topUnit);
        if (null == tenantInfo || null == tenantInfo.getUnitNumberLimit()) {
            return true;
        }
        return this.unitInfoDao.countUnitByTopUnit(topUnit) >= tenantInfo.getUnitNumberLimit();
    }
}

