/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenan.service.impl;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.tenan.dao.TenantInfoDao;
import com.centit.framework.tenan.po.TenantInfo;
import com.centit.framework.tenan.service.TenantPowerManage;
import com.centit.product.dao.WorkGroupDao;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class TenantPowerManageImpl
implements TenantPowerManage {
    protected Logger logger = LoggerFactory.getLogger(TenantPowerManage.class);
    @Autowired
    private TenantInfoDao tenantInfoDao;
    @Autowired
    private WorkGroupDao workGroupDao;
    @Autowired
    private UserUnitDao userUnitDao;

    @Override
    public boolean userIsTenantOwner(String userCode, String topUnit) {
        return this.tenantInfoDao.userIsOwner(topUnit, userCode);
    }

    @Override
    public boolean userIsTenantOwner(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantOwner(userCode, topUnit);
    }

    @Override
    public boolean userIsTenantAdmin(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit, "userCode", userCode, "roleCode", "ZHGLY"});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public String userTenantRole(String topUnit) {
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(302, "topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.userIsTenantOwner(topUnit)) {
            return "OWN";
        }
        if (this.userIsTenantAdmin(topUnit)) {
            return "ZHGLY";
        }
        if (this.userIsTenantMember(topUnit)) {
            return "ZHZY";
        }
        return "";
    }

    @Override
    public boolean userIsTenantAdmin(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantAdmin(userCode, topUnit);
    }

    @Override
    public boolean userIsTenantMember(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "topUnit", topUnit});
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listObjects(filterMap));
    }

    @Override
    public boolean userIsTenantMember(String topUnit) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsTenantMember(userCode, topUnit);
    }

    @Override
    public boolean userIsApplicationAdmin(String userCode, String osId) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode, "roleCode", "OSZZ"});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public boolean userIsApplicationAdmin(String osId) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsApplicationAdmin(userCode, osId);
    }

    @Override
    public boolean userIsApplicationMember(String userCode, String osId) throws ObjectException {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode});
        return this.workGroupDao.listObjectsByProperties(filterMap).size() > 0;
    }

    @Override
    public boolean userIsApplicationMember(String osId) throws ObjectException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return this.userIsApplicationMember(userCode, osId);
    }

    @Override
    public TenantInfo tenantResourceLimit(String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit, "isAvailable", "T"});
        List tenantInfos = this.tenantInfoDao.listObjectsByProperties(filterMap);
        if (CollectionUtils.sizeIsEmpty((Object)tenantInfos)) {
            return null;
        }
        return (TenantInfo)tenantInfos.get(0);
    }

    @Override
    public List<Map<String, Object>> tenantResourceUsed(String topUnit) {
        return null;
    }

    @Override
    public ArrayList<HashMap<String, Object>> tenantResourceDetails(String topUnit) {
        TenantInfo tenantInfo = this.tenantResourceLimit(topUnit);
        if (null == tenantInfo) {
            return new ArrayList<HashMap<String, Object>>();
        }
        List<Map<String, Object>> sourceTypeCount = this.tenantResourceUsed(topUnit);
        int databaseNumberLimit = tenantInfo.getDatabaseNumberLimit();
        int osNumberLimit = tenantInfo.getOsNumberLimit();
        int dataSpaceLimit = tenantInfo.getDataSpaceLimit();
        int fileSpaceLimit = tenantInfo.getFileSpaceLimit();
        ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        resultList.add(this.getSourceUseDetails(sourceTypeCount, databaseNumberLimit, "D"));
        resultList.add(this.getSourceUseDetails(sourceTypeCount, osNumberLimit, "O"));
        resultList.add(this.getSourceUseDetails(sourceTypeCount, dataSpaceLimit, "F"));
        resultList.add(this.getSourceUseDetails(sourceTypeCount, fileSpaceLimit, "C"));
        return resultList;
    }

    @Override
    public HashMap<String, Object> specialResourceDetails(String topUnit, String resourceType) {
        TenantInfo tenantInfo = this.tenantResourceLimit(topUnit);
        if (null == tenantInfo) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = this.tenantResourceUsed(topUnit, resourceType);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.getSourceUseDetails(maps, this.getResourceLimit(tenantInfo, resourceType), resourceType);
    }

    @Override
    public boolean userIsSystemMember(String userCode) {
        return this.userIsTenantMember(userCode, "system");
    }

    @Override
    public boolean userIsSystemMember() {
        return this.userIsTenantMember("system");
    }

    @Override
    public boolean userIsSystemAdmin(String userCode) {
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listUserUnitsByUserCode("system", userCode));
    }

    @Override
    public boolean userIsSystemAdmin() {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u7528\u6237\u672a\u767b\u5f55!");
        }
        return !CollectionUtils.sizeIsEmpty((Object)this.userUnitDao.listUserUnitsByUserCode("system", userCode));
    }

    private HashMap<String, Object> getSourceUseDetails(List<Map<String, Object>> sourceTypeCount, int numberLimit, String sourceType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int usedSource = this.usedSourceTypeCount(sourceTypeCount, sourceType);
        resultMap.put("sourceType", sourceType);
        resultMap.put("limit", numberLimit);
        resultMap.put("usedSource", usedSource);
        resultMap.put("useAble", numberLimit - usedSource < 0 ? 0 : numberLimit - usedSource);
        resultMap.put("isLimit", numberLimit - usedSource <= 0);
        return resultMap;
    }

    private int usedSourceTypeCount(List<Map<String, Object>> sourceTypeCount, String sourceType) {
        for (Map<String, Object> sourceMap : sourceTypeCount) {
            if (!sourceType.equals(MapUtils.getString(sourceMap, (Object)"sourceType"))) continue;
            return MapUtils.getInteger(sourceMap, (Object)"sourceTypeCount");
        }
        return 0;
    }

    public Map<String, Object> tenantResourceUsed(String topUnit, String sourceType) {
        return null;
    }

    private int getResourceLimit(TenantInfo tenantInfo, String resourceType) {
        switch (resourceType) {
            case "D": {
                return tenantInfo.getDatabaseNumberLimit();
            }
            case "O": {
                return tenantInfo.getOsNumberLimit();
            }
            case "F": {
                return tenantInfo.getFileSpaceLimit();
            }
            case "C": {
                return tenantInfo.getDataSpaceLimit();
            }
        }
        this.logger.warn("\u672a\u627e\u5230\u8d44\u6e90\u7c7b\u578b\u5bf9\u5e94\u7684\u4e0a\u9650\u503c!\u8d44\u6e90\u7c7b\u578bcode\u662f:{}", (Object)resourceType);
        return 0;
    }
}

