/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.tenan.dao;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.tenan.po.TenantInfo;
import com.centit.framework.tenan.vo.PageListTenantInfoQo;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TenantInfoDao
extends BaseDaoImpl<TenantInfo, String> {
    public List<TenantInfo> listObjectsByProperties(PageListTenantInfoQo pageListTenantInfoQo, PageDesc pageDesc) {
        HashMap<String, Object> filterMap = this.getQoFilterMap(pageListTenantInfoQo);
        return super.listObjectsByProperties(filterMap, pageDesc);
    }

    public JSONArray listTenantInfoWithOwnUserName(Map<String, Object> filterMap, PageDesc pageDesc) {
        String sql = " SELECT A.TOP_UNIT, A.UNIT_NAME, A.OWN_USER, B.USER_NAME FROM F_TENANT_INFO A JOIN  F_USERINFO B ON A.OWN_USER = B.USER_CODE WHERE   A.IS_AVAILABLE = 'T' [:(LIKE)unitName | AND A.UNIT_NAME LIKE :unitName ] order by A.UNIT_NAME ";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (PageDesc)pageDesc);
    }

    public List<TenantInfo> listUserTenant(Map<String, Object> filterMap) {
        String sql = " SELECT \nDISTINCT \nA.TOP_UNIT, A.UNIT_NAME,A.SOURCE_URL,A.OWN_USER\nFROM F_TENANT_INFO A  JOIN F_USERUNIT B ON A.TOP_UNIT = B.TOP_UNIT WHERE A.IS_AVAILABLE = 'T'   AND B.USER_CODE = :userCode ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)sql, (Map)filterMap, TenantInfo.class));
    }

    private HashMap<String, Object> getQoFilterMap(PageListTenantInfoQo pageListTenantInfoQo) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)pageListTenantInfoQo.getUnitName())) {
            filterMap.put("unitName_lk", StringUtils.join((Object[])new String[]{"%", pageListTenantInfoQo.getUnitName(), "%"}));
        }
        if (StringUtils.isNotBlank((CharSequence)pageListTenantInfoQo.getCheckState()) && pageListTenantInfoQo.getCheckState().equals("1")) {
            filterMap.put("passTime_nv", "");
        }
        if (StringUtils.isNotBlank((CharSequence)pageListTenantInfoQo.getCheckState()) && pageListTenantInfoQo.getCheckState().equals("2")) {
            filterMap.put("passTime_nn", "");
        }
        if (null != pageListTenantInfoQo.getStartApplyTime()) {
            filterMap.put("applyTime_ge", pageListTenantInfoQo.getStartApplyTime());
        }
        if (null != pageListTenantInfoQo.getEndApplyTime()) {
            filterMap.put("applyTime_le", pageListTenantInfoQo.getEndApplyTime());
        }
        if (null != pageListTenantInfoQo.getStartUseLimittime()) {
            filterMap.put("useLimittime_ge", pageListTenantInfoQo.getStartUseLimittime());
        }
        if (null != pageListTenantInfoQo.getEndUseLimittime()) {
            filterMap.put("useLimittime_le", pageListTenantInfoQo.getEndUseLimittime());
        }
        if (null != pageListTenantInfoQo.getStartPassTime()) {
            filterMap.put("passTime_ge", pageListTenantInfoQo.getStartPassTime());
        }
        if (null != pageListTenantInfoQo.getEndPassTime()) {
            filterMap.put("passTime_le", pageListTenantInfoQo.getEndPassTime());
        }
        if (StringUtils.isNotBlank((CharSequence)pageListTenantInfoQo.getIsAvailable())) {
            filterMap.put("isAvailable", pageListTenantInfoQo.getIsAvailable());
        }
        if (StringUtils.isNotBlank((CharSequence)pageListTenantInfoQo.getOwnUser())) {
            filterMap.put("ownUser", pageListTenantInfoQo.getOwnUser());
        }
        return filterMap;
    }

    public boolean userIsOwner(String topUnit, String userCode) {
        String sql = " SELECT COUNT(1) FROM `F_TENANT_INFO` WHERE TOP_UNIT = ? AND OWN_USER = ? ";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{topUnit, userCode})) > 0;
    }
}

