/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.function.pushmsg;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import java.util.HashMap;

public class JPushUtil {
    private static HashMap<String, HashMap<String, String>> apis = new HashMap();

    protected JPushUtil(String id, String apiKey, String secretKey) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("apiKey", apiKey);
        properties.put("secretKey", secretKey);
        apis.put(id, properties);
    }

    public boolean pushBroadcast(String id, String message) {
        HashMap<String, String> properties = apis.get(id);
        JPushClient jpushClient = new JPushClient(properties.get("secretKey"), properties.get("apiKey"), 3);
        PushPayload payload = PushPayload.alertAll((String)message);
        try {
            PushResult result = jpushClient.sendPush(payload);
            System.out.println("Got result - " + result);
            return true;
        }
        catch (APIConnectionException e) {
            System.err.println("Connection error, should retry later :" + e.getMessage());
            return false;
        }
        catch (APIRequestException e) {
            System.err.println("Should review the error, and fix the request :" + e.getMessage());
            System.err.println("HTTP Status: " + e.getStatus());
            System.err.println("Error Code: " + e.getErrorCode());
            System.err.println("Error Message: " + e.getErrorMessage());
            return false;
        }
    }

    public boolean pushUnicast(String id, String userId, String message) {
        HashMap<String, String> properties = apis.get(id);
        JPushClient jpushClient = new JPushClient(properties.get("secretKey"), properties.get("apiKey"), 3);
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{userId})).setNotification(Notification.alert((String)message)).setMessage(Message.content((String)message)).build();
        try {
            PushResult result = jpushClient.sendPush(payload);
            System.out.println("Got result - " + result);
            return true;
        }
        catch (APIConnectionException e) {
            System.err.println("Connection error, should retry later :" + e.getMessage());
            return false;
        }
        catch (APIRequestException e) {
            System.err.println("Should review the error, and fix the request :" + e.getMessage());
            System.err.println("HTTP Status: " + e.getStatus());
            System.err.println("Error Code: " + e.getErrorCode());
            System.err.println("Error Message: " + e.getErrorMessage());
            return false;
        }
    }
}

