/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.function.pushmsg;

import com.baidu.yun.channel.auth.ChannelKeyPair;
import com.baidu.yun.channel.client.BaiduChannelClient;
import com.baidu.yun.channel.exception.ChannelClientException;
import com.baidu.yun.channel.exception.ChannelServerException;
import com.baidu.yun.channel.model.PushBroadcastMessageRequest;
import com.baidu.yun.channel.model.PushBroadcastMessageResponse;
import com.baidu.yun.channel.model.PushUnicastMessageRequest;
import com.baidu.yun.channel.model.PushUnicastMessageResponse;
import com.baidu.yun.core.log.YunLogEvent;
import com.baidu.yun.core.log.YunLogHandler;
import java.util.HashMap;

public class BaiduCloudPushUtil {
    private static HashMap<String, HashMap<String, String>> apis = new HashMap();

    protected BaiduCloudPushUtil(String id, String apiKey, String secretKey) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("apiKey", apiKey);
        properties.put("secretKey", secretKey);
        apis.put(id, properties);
    }

    public boolean pushBroadcast(String id, String message) {
        HashMap<String, String> properties = apis.get(id);
        ChannelKeyPair pair = new ChannelKeyPair(properties.get("apiKey"), properties.get("secretKey"));
        BaiduChannelClient channelClient = new BaiduChannelClient(pair);
        channelClient.setChannelLogHandler(new YunLogHandler(){

            public void onHandle(YunLogEvent event) {
                System.out.println(event.getMessage());
            }
        });
        try {
            PushBroadcastMessageRequest request = new PushBroadcastMessageRequest();
            PushBroadcastMessageRequest requestI = new PushBroadcastMessageRequest();
            request.setDeviceType(Integer.valueOf(3));
            requestI.setDeviceType(Integer.valueOf(4));
            request.setMessageType(Integer.valueOf(1));
            request.setMessage(message);
            requestI.setDeployStatus(Integer.valueOf(2));
            requestI.setMessageType(Integer.valueOf(1));
            requestI.setMessage(message);
            PushBroadcastMessageResponse response = channelClient.pushBroadcastMessage(request);
            PushBroadcastMessageResponse responseI = channelClient.pushBroadcastMessage(requestI);
            int num = response.getSuccessAmount() + responseI.getSuccessAmount();
            return num >= 2;
        }
        catch (ChannelClientException e) {
            e.printStackTrace();
            return false;
        }
        catch (ChannelServerException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean pushUnicast(String id, long channelId, String userId, int deviceType, String message) {
        HashMap<String, String> properties = apis.get(id);
        ChannelKeyPair pair = new ChannelKeyPair(properties.get("apiKey"), properties.get("secretKey"));
        BaiduChannelClient channelClient = new BaiduChannelClient(pair);
        channelClient.setChannelLogHandler(new YunLogHandler(){

            public void onHandle(YunLogEvent event) {
                System.out.println(event.getMessage());
            }
        });
        try {
            PushUnicastMessageRequest requestI = new PushUnicastMessageRequest();
            requestI.setDeviceType(Integer.valueOf(deviceType));
            requestI.setChannelId(Long.valueOf(channelId));
            requestI.setUserId(userId);
            requestI.setDeployStatus(Integer.valueOf(2));
            requestI.setMessageType(Integer.valueOf(1));
            requestI.setMessage(message);
            PushUnicastMessageResponse responseI = channelClient.pushUnicastMessage(requestI);
            return responseI.getSuccessAmount() > 0;
        }
        catch (ChannelClientException e) {
            e.printStackTrace();
            return false;
        }
        catch (ChannelServerException e) {
            e.printStackTrace();
            return false;
        }
    }
}

