/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DataChangeRecorderInnerInterceptor
implements InnerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String IGNORED_TABLE_COLUMN_PROPERTIES = "ignoredTableColumns";
    private final Map<String, Set<String>> ignoredTableColumns = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> ignoreAllColumns = new HashSet<String>();
    private int BATCH_UPDATE_LIMIT = 1000;
    private boolean batchUpdateLimitationOpened = false;
    private final Map<String, Integer> BATCH_UPDATE_LIMIT_MAP = new ConcurrentHashMap<String, Integer>();

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        BoundSql boundSql = mpSh.boundSql();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            OperationResult operationResult;
            long startTs;
            block8: {
                PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
                startTs = System.currentTimeMillis();
                try {
                    Statement statement = JsqlParserGlobal.parse(mpBs.sql());
                    if (statement instanceof Insert) {
                        operationResult = this.processInsert((Insert)statement, mpSh.boundSql());
                        break block8;
                    }
                    if (statement instanceof Update) {
                        operationResult = this.processUpdate((Update)statement, ms, boundSql, connection);
                        break block8;
                    }
                    if (statement instanceof Delete) {
                        operationResult = this.processDelete((Delete)statement, ms, boundSql, connection);
                        break block8;
                    }
                    this.logger.info("other operation sql={}", (Object)mpBs.sql());
                    return;
                }
                catch (Exception e) {
                    if (e instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)e);
                    }
                    this.logger.error("Unexpected error for mappedStatement={}, sql={}", new Object[]{ms.getId(), mpBs.sql(), e});
                    return;
                }
            }
            long costThis = System.currentTimeMillis() - startTs;
            if (operationResult != null) {
                operationResult.setCost(costThis);
                this.dealOperationResult(operationResult);
            }
        }
    }

    protected boolean allowProcess(String sql) {
        String sqlTrim = sql.trim().toUpperCase();
        return sqlTrim.startsWith("INSERT") || sqlTrim.startsWith("UPDATE") || sqlTrim.startsWith("DELETE");
    }

    protected void dealOperationResult(OperationResult operationResult) {
        this.logger.info("{}", (Object)operationResult);
    }

    public OperationResult processInsert(Insert insertStmt, BoundSql boundSql) {
        String operation = SqlCommandType.INSERT.name().toLowerCase();
        Table table = insertStmt.getTable();
        String tableName = table.getName();
        Optional<OperationResult> optionalOperationResult = this.ignoredTableColumns(tableName, operation);
        if (optionalOperationResult.isPresent()) {
            return optionalOperationResult.get();
        }
        OperationResult result = new OperationResult();
        result.setOperation(operation);
        result.setTableName(tableName);
        result.setRecordStatus(true);
        Map<String, Object> updatedColumnDatas = this.getUpdatedColumnDatas(tableName, boundSql, (Statement)insertStmt);
        result.buildDataStr(this.compareAndGetUpdatedColumnDatas(result.getTableName(), null, updatedColumnDatas));
        return result;
    }

    public OperationResult processUpdate(Update updateStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        String operation;
        Expression where = updateStmt.getWhere();
        PlainSelect selectBody = new PlainSelect();
        Table table = updateStmt.getTable();
        String tableName = table.getName();
        Optional<OperationResult> optionalOperationResult = this.ignoredTableColumns(tableName, operation = SqlCommandType.UPDATE.name().toLowerCase());
        if (optionalOperationResult.isPresent()) {
            return optionalOperationResult.get();
        }
        selectBody.setFromItem((FromItem)table);
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
            updateColumns.addAll((Collection<Column>)updateSet.getColumns());
        }
        Columns2SelectItemsResult buildColumns2SelectItems = this.buildColumns2SelectItems(tableName, updateColumns);
        selectBody.setSelectItems(buildColumns2SelectItems.getSelectItems());
        selectBody.setWhere(where);
        SelectItem plainSelectSelectItem = new SelectItem((Expression)selectBody);
        BoundSql boundSql4Select = new BoundSql(mappedStatement.getConfiguration(), plainSelectSelectItem.toString(), this.prepareParameterMapping4Select(boundSql.getParameterMappings(), updateStmt), boundSql.getParameterObject());
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        Map additionalParameters = mpBoundSql.additionalParameters();
        if (additionalParameters != null && !additionalParameters.isEmpty()) {
            for (Map.Entry ety : additionalParameters.entrySet()) {
                boundSql4Select.setAdditionalParameter((String)ety.getKey(), ety.getValue());
            }
        }
        Map<String, Object> updatedColumnDatas = this.getUpdatedColumnDatas(tableName, boundSql, (Statement)updateStmt);
        OriginalDataObj originalData = this.buildOriginalObjectData(updatedColumnDatas, (Select)selectBody, buildColumns2SelectItems.getPk(), mappedStatement, boundSql4Select, connection);
        OperationResult result = new OperationResult();
        result.setOperation(operation);
        result.setTableName(tableName);
        result.setRecordStatus(true);
        result.buildDataStr(this.compareAndGetUpdatedColumnDatas(result.getTableName(), originalData, updatedColumnDatas));
        return result;
    }

    private Optional<OperationResult> ignoredTableColumns(String table, String operation) {
        Set<String> ignoredColumns = this.ignoredTableColumns.get(table.toUpperCase());
        if (ignoredColumns != null && ignoredColumns.stream().anyMatch("*"::equals)) {
            OperationResult result = new OperationResult();
            result.setOperation(operation);
            result.setTableName(table + ":*");
            result.setRecordStatus(false);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private TableInfo getTableInfoByTableName(String tableName) {
        for (TableInfo tableInfo : TableInfoHelper.getTableInfos()) {
            if (!tableName.equalsIgnoreCase(tableInfo.getTableName())) continue;
            return tableInfo;
        }
        return null;
    }

    private List<ParameterMapping> prepareParameterMapping4Select(List<ParameterMapping> originalMappingList, Update updateStmt) {
        ArrayList updateValueExpressions = new ArrayList();
        for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
            updateValueExpressions.addAll(updateSet.getValues());
        }
        int removeParamCount = 0;
        for (Expression expression : updateValueExpressions) {
            if (!(expression instanceof JdbcParameter)) continue;
            ++removeParamCount;
        }
        return originalMappingList.subList(removeParamCount, originalMappingList.size());
    }

    protected Map<String, Object> getUpdatedColumnDatas(String tableName, BoundSql updateSql, Statement statement) {
        HashMap<String, Object> columnNameValMap = new HashMap<String, Object>(updateSql.getParameterMappings().size());
        HashMap<Integer, String> columnSetIndexMap = new HashMap<Integer, String>(updateSql.getParameterMappings().size());
        ArrayList selectItemsFromUpdateSql = new ArrayList();
        if (statement instanceof Update) {
            Update updateStmt = (Update)statement;
            int index = 0;
            for (UpdateSet updateSet : updateStmt.getUpdateSets()) {
                selectItemsFromUpdateSql.addAll(updateSet.getColumns());
                ExpressionList updateList = updateSet.getValues();
                for (int i = 0; i < updateList.size(); ++i) {
                    Expression updateExps = (Expression)updateList.get(i);
                    if (!(updateExps instanceof JdbcParameter)) {
                        columnNameValMap.put(((Column)updateSet.getColumns().get(i)).getColumnName().toUpperCase(), updateExps.toString());
                    }
                    columnSetIndexMap.put(index++, ((Column)updateSet.getColumns().get(i)).getColumnName().toUpperCase());
                }
            }
        } else if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            selectItemsFromUpdateSql.addAll(insert.getColumns());
            columnNameValMap.putAll(this.detectInsertColumnValuesNonJdbcParameters(insert));
        }
        HashMap<String, String> relatedColumnsUpperCaseWithoutUnderline = new HashMap<String, String>(selectItemsFromUpdateSql.size(), 1.0f);
        for (Column item : selectItemsFromUpdateSql) {
            relatedColumnsUpperCaseWithoutUnderline.put(item.getColumnName().replaceAll("[._\\-$]", "").toUpperCase(), item.getColumnName().toUpperCase());
        }
        MetaObject metaObject = SystemMetaObject.forObject((Object)updateSql.getParameterObject());
        int index = 0;
        for (ParameterMapping parameterMapping : updateSql.getParameterMappings()) {
            String propertyName = parameterMapping.getProperty();
            if (propertyName.startsWith("ew.paramNameValuePairs")) {
                ++index;
                continue;
            }
            String[] arr = propertyName.split("\\.");
            String propertyNameTrim = arr[arr.length - 1].replace("_", "").toUpperCase();
            try {
                String columnName = columnSetIndexMap.getOrDefault(index++, this.getColumnNameByProperty(propertyNameTrim, tableName));
                if (relatedColumnsUpperCaseWithoutUnderline.containsKey(propertyNameTrim)) {
                    String colkey = (String)relatedColumnsUpperCaseWithoutUnderline.get(propertyNameTrim);
                    Object valObj = metaObject.getValue(propertyName);
                    if (valObj instanceof IEnum) {
                        valObj = ((IEnum)valObj).getValue();
                    } else if (valObj instanceof Enum) {
                        valObj = this.getEnumValue((Enum)valObj);
                    }
                    if (columnNameValMap.containsKey(colkey)) {
                        columnNameValMap.put((String)relatedColumnsUpperCaseWithoutUnderline.get(propertyNameTrim), String.valueOf(columnNameValMap.get(colkey)).replace("?", valObj == null ? "" : valObj.toString()));
                    }
                    if (columnName == null || columnNameValMap.containsKey(columnName)) continue;
                    columnNameValMap.put(columnName, valObj);
                    continue;
                }
                if (columnName == null) continue;
                columnNameValMap.put(columnName, metaObject.getValue(propertyName));
            }
            catch (Exception e) {
                this.logger.warn("get value error,propertyName:{},parameterMapping:{}", (Object)propertyName, (Object)parameterMapping);
            }
        }
        this.dealWithUpdateWrapper(columnSetIndexMap, columnNameValMap, updateSql);
        return columnNameValMap;
    }

    private List<DataChangedRecord> compareAndGetUpdatedColumnDatas(String tableName, OriginalDataObj originalDataObj, Map<String, Object> columnNameValMap) {
        Set<String> ignoredColumns = this.ignoredTableColumns.get(tableName.toUpperCase());
        if (originalDataObj == null || originalDataObj.isEmpty()) {
            DataChangedRecord oneRecord = new DataChangedRecord();
            ArrayList<DataColumnChangeResult> updateColumns = new ArrayList<DataColumnChangeResult>(columnNameValMap.size());
            for (Map.Entry<String, Object> ety : columnNameValMap.entrySet()) {
                String columnName = ety.getKey();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || this.ignoreAllColumns.contains(columnName)) continue;
                updateColumns.add(DataColumnChangeResult.constrcutByUpdateVal(columnName, ety.getValue()));
            }
            oneRecord.setUpdatedColumns(updateColumns);
            return Collections.singletonList(oneRecord);
        }
        List<DataChangedRecord> originalDataList = originalDataObj.getOriginalDataObj();
        ArrayList<DataChangedRecord> updateDataList = new ArrayList<DataChangedRecord>(originalDataList.size());
        for (DataChangedRecord originalData : originalDataList) {
            if (!originalData.hasUpdate(columnNameValMap, ignoredColumns, this.ignoreAllColumns)) continue;
            updateDataList.add(originalData);
        }
        return updateDataList;
    }

    private Object getEnumValue(Enum enumVal) {
        Optional enumValueFieldName = MybatisEnumTypeHandler.findEnumValueFieldName(enumVal.getClass());
        if (enumValueFieldName.isPresent()) {
            return SystemMetaObject.forObject((Object)enumVal).getValue((String)enumValueFieldName.get());
        }
        return enumVal;
    }

    private void dealWithUpdateWrapper(Map<Integer, String> columnSetIndexMap, Map<String, Object> columnNameValMap, BoundSql updateSql) {
        if (columnSetIndexMap.size() <= columnNameValMap.size()) {
            return;
        }
        MetaObject mpgenVal = SystemMetaObject.forObject((Object)updateSql.getParameterObject());
        if (!mpgenVal.hasGetter("ew")) {
            return;
        }
        Object ew = mpgenVal.getValue("ew");
        if (ew instanceof UpdateWrapper || ew instanceof LambdaUpdateWrapper) {
            String[] setItems;
            String sqlSet;
            String string = sqlSet = ew instanceof UpdateWrapper ? ((UpdateWrapper)ew).getSqlSet() : ((LambdaUpdateWrapper)ew).getSqlSet();
            if (sqlSet == null) {
                return;
            }
            MetaObject ewMeta = SystemMetaObject.forObject((Object)ew);
            Map paramNameValuePairs = (Map)ewMeta.getValue("paramNameValuePairs");
            for (String setItem : setItems = sqlSet.split(",")) {
                String[] nameAndValuePair = setItem.split("=", 2);
                if (nameAndValuePair.length != 2) continue;
                String setColName = nameAndValuePair[0].trim().toUpperCase();
                String setColVal = nameAndValuePair[1].trim();
                if (!columnSetIndexMap.containsValue(setColName)) continue;
                String[] mpGenKeyArray = setColVal.split("\\.");
                String mpGenKey = mpGenKeyArray[mpGenKeyArray.length - 1].replace("}", "");
                Object setVal = paramNameValuePairs.get(mpGenKey);
                if (setVal instanceof IEnum) {
                    columnNameValMap.put(setColName, String.valueOf(((IEnum)setVal).getValue()));
                    continue;
                }
                columnNameValMap.put(setColName, setVal);
            }
        }
    }

    private Map<String, String> detectInsertColumnValuesNonJdbcParameters(Insert insert) {
        HashMap<String, String> columnNameValMap = new HashMap<String, String>(4);
        Select select = insert.getSelect();
        ExpressionList columns = insert.getColumns();
        if (select instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)select;
            List selects = setOperationList.getSelects();
            if (CollectionUtils.isEmpty((Collection)selects)) {
                return columnNameValMap;
            }
            Select selectBody = (Select)selects.get(0);
            if (!(selectBody instanceof Values)) {
                return columnNameValMap;
            }
            Values valuesStatement = (Values)selectBody;
            if (valuesStatement.getExpressions() instanceof ExpressionList) {
                ExpressionList expressionList;
                ExpressionList expressions = expressionList = valuesStatement.getExpressions();
                for (Expression expression : expressions) {
                    RowConstructor exprList;
                    if (!(expression instanceof RowConstructor)) continue;
                    RowConstructor insertExpList = exprList = (RowConstructor)expression;
                    for (int i = 0; i < insertExpList.size(); ++i) {
                        Expression e = (Expression)insertExpList.get(i);
                        if (e instanceof JdbcParameter) continue;
                        String columnName = ((Column)columns.get(i)).getColumnName();
                        String val = e.toString();
                        columnNameValMap.put(columnName, val);
                    }
                }
            }
        }
        return columnNameValMap;
    }

    private String getColumnNameByProperty(String propertyName, String tableName) {
        for (TableInfo tableInfo : TableInfoHelper.getTableInfos()) {
            if (!tableName.equalsIgnoreCase(tableInfo.getTableName())) continue;
            List fieldList = tableInfo.getFieldList();
            if (CollectionUtils.isEmpty((Collection)fieldList)) {
                return propertyName;
            }
            for (TableFieldInfo tableFieldInfo : fieldList) {
                if (!propertyName.equalsIgnoreCase(tableFieldInfo.getProperty())) continue;
                return tableFieldInfo.getColumn().toUpperCase();
            }
            return propertyName;
        }
        return propertyName;
    }

    private Map<String, Object> buildParameterObjectMap(BoundSql boundSql) {
        MetaObject metaObject = PluginUtils.getMetaObject((Object)boundSql.getParameterObject());
        HashMap<String, Object> propertyValMap = new HashMap<String, Object>(boundSql.getParameterMappings().size());
        for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
            String propertyName = parameterMapping.getProperty();
            if (propertyName.startsWith("ew.paramNameValuePairs")) continue;
            Object propertyValue = metaObject.getValue(propertyName);
            propertyValMap.put(propertyName, propertyValue);
        }
        return propertyValMap;
    }

    private String buildOriginalData(Select selectStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        String string;
        block14: {
            PreparedStatement statement = connection.prepareStatement(selectStmt.toString());
            try {
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
                parameterHandler.setParameters(statement);
                ResultSet resultSet = statement.executeQuery();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                StringBuilder sb = new StringBuilder("[");
                int count = 0;
                while (resultSet.next()) {
                    if (this.checkTableBatchLimitExceeded(selectStmt, ++count)) {
                        this.logger.error("batch delete limit exceed: count={}, BATCH_UPDATE_LIMIT={}", (Object)count, (Object)this.BATCH_UPDATE_LIMIT);
                        throw DataUpdateLimitationException.DEFAULT;
                    }
                    sb.append("{");
                    for (int i = 1; i <= columnCount; ++i) {
                        sb.append("\"").append(metaData.getColumnName(i)).append("\":\"");
                        Object res = resultSet.getObject(i);
                        if (res instanceof Clob) {
                            sb.append(DataColumnChangeResult.convertClob((Clob)res));
                        } else {
                            sb.append(res);
                        }
                        sb.append("\",");
                    }
                    sb.replace(sb.length() - 1, sb.length(), "}");
                }
                sb.append("]");
                resultSet.close();
                string = sb.toString();
                if (statement == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)e);
                    }
                    this.logger.error("try to get record tobe deleted for selectStmt={}", (Object)selectStmt, (Object)e);
                    return "failed to get original data";
                }
            }
            statement.close();
        }
        return string;
    }

    private OriginalDataObj buildOriginalObjectData(Map<String, Object> updatedColumnDatas, Select selectStmt, Column pk, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        OriginalDataObj originalDataObj;
        block11: {
            PreparedStatement statement = connection.prepareStatement(selectStmt.toString());
            try {
                DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
                parameterHandler.setParameters(statement);
                ResultSet resultSet = statement.executeQuery();
                LinkedList<DataChangedRecord> originalObjectDatas = new LinkedList<DataChangedRecord>();
                int count = 0;
                while (resultSet.next()) {
                    if (this.checkTableBatchLimitExceeded(selectStmt, ++count)) {
                        this.logger.error("batch update limit exceed: count={}, BATCH_UPDATE_LIMIT={}", (Object)count, (Object)this.BATCH_UPDATE_LIMIT);
                        throw DataUpdateLimitationException.DEFAULT;
                    }
                    originalObjectDatas.add(this.prepareOriginalDataObj(updatedColumnDatas, resultSet, pk));
                }
                OriginalDataObj result = new OriginalDataObj();
                result.setOriginalDataObj(originalObjectDatas);
                resultSet.close();
                originalDataObj = result;
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof DataUpdateLimitationException) {
                        throw (DataUpdateLimitationException)((Object)e);
                    }
                    this.logger.error("try to get record tobe updated for selectStmt={}", (Object)selectStmt, (Object)e);
                    return new OriginalDataObj();
                }
            }
            statement.close();
        }
        return originalDataObj;
    }

    private boolean checkTableBatchLimitExceeded(Select selectStmt, int count) {
        if (!this.batchUpdateLimitationOpened) {
            return false;
        }
        PlainSelect selectBody = (PlainSelect)selectStmt;
        FromItem fromItem = selectBody.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            String tableName = fromTable.getName().toUpperCase();
            if (!this.BATCH_UPDATE_LIMIT_MAP.containsKey(tableName)) {
                if (count > this.BATCH_UPDATE_LIMIT) {
                    this.logger.error("batch update limit exceed for tableName={}, BATCH_UPDATE_LIMIT={}, count={}", new Object[]{tableName, this.BATCH_UPDATE_LIMIT, count});
                    return true;
                }
                return false;
            }
            Integer limit = this.BATCH_UPDATE_LIMIT_MAP.get(tableName);
            if (count > limit) {
                this.logger.error("batch update limit exceed for configured tableName={}, BATCH_UPDATE_LIMIT={}, count={}", new Object[]{tableName, limit, count});
                return true;
            }
            return false;
        }
        return count > this.BATCH_UPDATE_LIMIT;
    }

    private DataChangedRecord prepareOriginalDataObj(Map<String, Object> updatedColumnDatas, ResultSet resultSet, Column pk) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        LinkedList<DataColumnChangeResult> originalColumnDatas = new LinkedList<DataColumnChangeResult>();
        DataColumnChangeResult pkval = null;
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i).toUpperCase();
            Object updateVal = updatedColumnDatas.get(columnName);
            DataColumnChangeResult col = updateVal != null && updateVal.getClass().getCanonicalName().startsWith("java.") ? DataColumnChangeResult.constrcutByOriginalVal(columnName, resultSet.getObject(i, updateVal.getClass())) : DataColumnChangeResult.constrcutByOriginalVal(columnName, resultSet.getObject(i));
            if (pk != null && columnName.equalsIgnoreCase(pk.getColumnName())) {
                pkval = col;
                continue;
            }
            originalColumnDatas.add(col);
        }
        DataChangedRecord changedRecord = new DataChangedRecord();
        changedRecord.setOriginalColumnDatas(originalColumnDatas);
        if (pkval != null) {
            changedRecord.setPkColumnName(pkval.getColumnName());
            changedRecord.setPkColumnVal(pkval.getOriginalValue());
        }
        return changedRecord;
    }

    private Columns2SelectItemsResult buildColumns2SelectItems(String tableName, List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return Columns2SelectItemsResult.build(Collections.singletonList(new SelectItem((Expression)new AllColumns())), 0);
        }
        ArrayList selectItems = new ArrayList(columns.size());
        for (Column column : columns) {
            selectItems.add(new SelectItem((Expression)column));
        }
        TableInfo tableInfo = this.getTableInfoByTableName(tableName);
        if (tableInfo == null || StringUtils.isBlank((CharSequence)tableInfo.getKeyColumn())) {
            return Columns2SelectItemsResult.build(selectItems, 0);
        }
        Column pk = new Column(tableInfo.getKeyColumn());
        selectItems.add(new SelectItem((Expression)pk));
        Columns2SelectItemsResult result = Columns2SelectItemsResult.build(selectItems, 1);
        result.setPk(pk);
        return result;
    }

    private String buildParameterObject(BoundSql boundSql) {
        Object paramObj = boundSql.getParameterObject();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (paramObj instanceof Map) {
            String key;
            Map paramMap = (Map)paramObj;
            int index = 1;
            boolean hasParamIndex = false;
            while (paramMap.containsKey(key = "param" + index)) {
                Object paramIndex = paramMap.get(key);
                sb.append("\"").append(key).append("\"").append(":").append("\"").append(paramIndex).append("\"").append(",");
                hasParamIndex = true;
                ++index;
            }
            if (hasParamIndex) {
                sb.delete(sb.length() - 1, sb.length());
                sb.append("}");
                return sb.toString();
            }
            for (Map.Entry ety : paramMap.entrySet()) {
                sb.append("\"").append((String)ety.getKey()).append("\"").append(":").append("\"").append(ety.getValue()).append("\"").append(",");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append("}");
            return sb.toString();
        }
        sb.append("param:").append(paramObj);
        sb.append("}");
        return sb.toString();
    }

    public OperationResult processDelete(Delete deleteStmt, MappedStatement mappedStatement, BoundSql boundSql, Connection connection) {
        Table table = deleteStmt.getTable();
        Expression where = deleteStmt.getWhere();
        PlainSelect selectBody = new PlainSelect();
        selectBody.setFromItem((FromItem)table);
        selectBody.setSelectItems(Collections.singletonList(new SelectItem((Expression)new AllColumns())));
        selectBody.setWhere(where);
        String originalData = this.buildOriginalData((Select)selectBody, mappedStatement, boundSql, connection);
        OperationResult result = new OperationResult();
        result.setOperation("delete");
        result.setTableName(table.getName());
        result.setRecordStatus(originalData.startsWith("["));
        result.setChangedData(originalData);
        return result;
    }

    public DataChangeRecorderInnerInterceptor setBatchUpdateLimit(int limit) {
        this.BATCH_UPDATE_LIMIT = limit;
        return this;
    }

    public DataChangeRecorderInnerInterceptor openBatchUpdateLimitation() {
        this.batchUpdateLimitationOpened = true;
        return this;
    }

    public DataChangeRecorderInnerInterceptor configTableLimitation(String tableName, int limit) {
        this.BATCH_UPDATE_LIMIT_MAP.put(tableName.toUpperCase(), limit);
        return this;
    }

    public void setProperties(Properties properties) {
        String[] array;
        String ignoredTableColumns = properties.getProperty(IGNORED_TABLE_COLUMN_PROPERTIES);
        if (ignoredTableColumns == null || ignoredTableColumns.trim().isEmpty()) {
            return;
        }
        for (String table : array = ignoredTableColumns.split(";")) {
            int index = table.indexOf(".");
            if (index == -1) {
                this.logger.warn("invalid data={} for ignoredColumns, format should be TABLE_NAME1.COLUMN1,COLUMN2; TABLE2.COLUMN1,COLUMN2;", (Object)table);
                continue;
            }
            String tableName = table.substring(0, index).trim().toUpperCase();
            String[] columnArray = table.substring(index + 1).split(",");
            HashSet<String> columnSet = new HashSet<String>(columnArray.length);
            for (String column : columnArray) {
                if ((column = column.trim().toUpperCase()).isEmpty()) continue;
                columnSet.add(column);
            }
            if ("*".equals(tableName)) {
                this.ignoreAllColumns.addAll(columnSet);
                continue;
            }
            this.ignoredTableColumns.put(tableName, columnSet);
        }
    }

    public static class OperationResult {
        private String operation;
        private boolean recordStatus;
        private String tableName;
        private String changedData;
        private long cost;

        public void buildDataStr(List<DataChangedRecord> records) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (DataChangedRecord r : records) {
                sb.append(r.generateUpdatedDataStr()).append(",");
            }
            if (sb.length() == 1) {
                sb.append("]");
                this.changedData = sb.toString();
                return;
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
            this.changedData = sb.toString();
        }

        public String toString() {
            return "{\"tableName\":\"" + this.tableName + "\",\"operation\":\"" + this.operation + "\",\"recordStatus\":\"" + this.recordStatus + "\",\"changedData\":" + this.changedData + ",\"cost(ms)\":" + this.cost + "}";
        }

        public String getOperation() {
            return this.operation;
        }

        public boolean isRecordStatus() {
            return this.recordStatus;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getChangedData() {
            return this.changedData;
        }

        public long getCost() {
            return this.cost;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setRecordStatus(boolean recordStatus) {
            this.recordStatus = recordStatus;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setChangedData(String changedData) {
            this.changedData = changedData;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationResult)) {
                return false;
            }
            OperationResult other = (OperationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRecordStatus() != other.isRecordStatus()) {
                return false;
            }
            if (this.getCost() != other.getCost()) {
                return false;
            }
            String this$operation = this.getOperation();
            String other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$changedData = this.getChangedData();
            String other$changedData = other.getChangedData();
            return !(this$changedData == null ? other$changedData != null : !this$changedData.equals(other$changedData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OperationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRecordStatus() ? 79 : 97);
            long $cost = this.getCost();
            result = result * 59 + (int)($cost >>> 32 ^ $cost);
            String $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $changedData = this.getChangedData();
            result = result * 59 + ($changedData == null ? 43 : $changedData.hashCode());
            return result;
        }
    }

    public static class DataUpdateLimitationException
    extends MybatisPlusException {
        public static DataUpdateLimitationException DEFAULT = new DataUpdateLimitationException("\u672c\u6b21\u64cd\u4f5c \u56e0\u8d85\u8fc7\u7cfb\u7edf\u5b89\u5168\u9608\u503c \u88ab\u62e6\u622a\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");

        public DataUpdateLimitationException(String message) {
            super(message);
        }
    }

    public static class OriginalDataObj {
        private List<DataChangedRecord> originalDataObj;

        public boolean isEmpty() {
            return this.originalDataObj == null || this.originalDataObj.isEmpty();
        }

        public List<DataChangedRecord> getOriginalDataObj() {
            return this.originalDataObj;
        }

        public void setOriginalDataObj(List<DataChangedRecord> originalDataObj) {
            this.originalDataObj = originalDataObj;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginalDataObj)) {
                return false;
            }
            OriginalDataObj other = (OriginalDataObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<DataChangedRecord> this$originalDataObj = this.getOriginalDataObj();
            List<DataChangedRecord> other$originalDataObj = other.getOriginalDataObj();
            return !(this$originalDataObj == null ? other$originalDataObj != null : !((Object)this$originalDataObj).equals(other$originalDataObj));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OriginalDataObj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DataChangedRecord> $originalDataObj = this.getOriginalDataObj();
            result = result * 59 + ($originalDataObj == null ? 43 : ((Object)$originalDataObj).hashCode());
            return result;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.OriginalDataObj(originalDataObj=" + this.getOriginalDataObj() + ")";
        }
    }

    public static class Columns2SelectItemsResult {
        private Column pk;
        private List<SelectItem<?>> selectItems;
        private int additionalItemCount;

        public static Columns2SelectItemsResult build(List<SelectItem<?>> selectItems, int additionalItemCount) {
            Columns2SelectItemsResult result = new Columns2SelectItemsResult();
            result.setSelectItems(selectItems);
            result.setAdditionalItemCount(additionalItemCount);
            return result;
        }

        public Column getPk() {
            return this.pk;
        }

        public List<SelectItem<?>> getSelectItems() {
            return this.selectItems;
        }

        public int getAdditionalItemCount() {
            return this.additionalItemCount;
        }

        public void setPk(Column pk) {
            this.pk = pk;
        }

        public void setSelectItems(List<SelectItem<?>> selectItems) {
            this.selectItems = selectItems;
        }

        public void setAdditionalItemCount(int additionalItemCount) {
            this.additionalItemCount = additionalItemCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Columns2SelectItemsResult)) {
                return false;
            }
            Columns2SelectItemsResult other = (Columns2SelectItemsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAdditionalItemCount() != other.getAdditionalItemCount()) {
                return false;
            }
            Column this$pk = this.getPk();
            Column other$pk = other.getPk();
            if (this$pk == null ? other$pk != null : !this$pk.equals(other$pk)) {
                return false;
            }
            List<SelectItem<?>> this$selectItems = this.getSelectItems();
            List<SelectItem<?>> other$selectItems = other.getSelectItems();
            return !(this$selectItems == null ? other$selectItems != null : !((Object)this$selectItems).equals(other$selectItems));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Columns2SelectItemsResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAdditionalItemCount();
            Column $pk = this.getPk();
            result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
            List<SelectItem<?>> $selectItems = this.getSelectItems();
            result = result * 59 + ($selectItems == null ? 43 : ((Object)$selectItems).hashCode());
            return result;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.Columns2SelectItemsResult(pk=" + this.getPk() + ", selectItems=" + this.getSelectItems() + ", additionalItemCount=" + this.getAdditionalItemCount() + ")";
        }
    }

    public static class DataChangedRecord {
        private String pkColumnName;
        private Object pkColumnVal;
        private List<DataColumnChangeResult> originalColumnDatas;
        private List<DataColumnChangeResult> updatedColumns;

        public boolean hasUpdate(Map<String, Object> columnNameValMap, Set<String> ignoredColumns, Set<String> ignoreAllColumns) {
            if (this.originalColumnDatas == null) {
                return true;
            }
            boolean hasUpdate = false;
            this.updatedColumns = new ArrayList<DataColumnChangeResult>(this.originalColumnDatas.size());
            for (DataColumnChangeResult originalColumn : this.originalColumnDatas) {
                Object updatedValue;
                String columnName = originalColumn.getColumnName().toUpperCase();
                if (ignoredColumns != null && ignoredColumns.contains(columnName) || ignoreAllColumns.contains(columnName) || !originalColumn.isDataChanged(updatedValue = columnNameValMap.get(columnName))) continue;
                hasUpdate = true;
                originalColumn.setUpdateValue(updatedValue);
                this.updatedColumns.add(originalColumn);
            }
            return hasUpdate;
        }

        public String generateUpdatedDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.pkColumnName != null) {
                sb.append("\"").append(this.pkColumnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.pkColumnVal)).append("\"").append(",");
            }
            for (DataColumnChangeResult update : this.updatedColumns) {
                sb.append(update.generateDataStr());
            }
            sb.replace(sb.length() - 1, sb.length(), "}");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public Object getPkColumnVal() {
            return this.pkColumnVal;
        }

        public List<DataColumnChangeResult> getOriginalColumnDatas() {
            return this.originalColumnDatas;
        }

        public List<DataColumnChangeResult> getUpdatedColumns() {
            return this.updatedColumns;
        }

        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }

        public void setPkColumnVal(Object pkColumnVal) {
            this.pkColumnVal = pkColumnVal;
        }

        public void setOriginalColumnDatas(List<DataColumnChangeResult> originalColumnDatas) {
            this.originalColumnDatas = originalColumnDatas;
        }

        public void setUpdatedColumns(List<DataColumnChangeResult> updatedColumns) {
            this.updatedColumns = updatedColumns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataChangedRecord)) {
                return false;
            }
            DataChangedRecord other = (DataChangedRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pkColumnName = this.getPkColumnName();
            String other$pkColumnName = other.getPkColumnName();
            if (this$pkColumnName == null ? other$pkColumnName != null : !this$pkColumnName.equals(other$pkColumnName)) {
                return false;
            }
            Object this$pkColumnVal = this.getPkColumnVal();
            Object other$pkColumnVal = other.getPkColumnVal();
            if (this$pkColumnVal == null ? other$pkColumnVal != null : !this$pkColumnVal.equals(other$pkColumnVal)) {
                return false;
            }
            List<DataColumnChangeResult> this$originalColumnDatas = this.getOriginalColumnDatas();
            List<DataColumnChangeResult> other$originalColumnDatas = other.getOriginalColumnDatas();
            if (this$originalColumnDatas == null ? other$originalColumnDatas != null : !((Object)this$originalColumnDatas).equals(other$originalColumnDatas)) {
                return false;
            }
            List<DataColumnChangeResult> this$updatedColumns = this.getUpdatedColumns();
            List<DataColumnChangeResult> other$updatedColumns = other.getUpdatedColumns();
            return !(this$updatedColumns == null ? other$updatedColumns != null : !((Object)this$updatedColumns).equals(other$updatedColumns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataChangedRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pkColumnName = this.getPkColumnName();
            result = result * 59 + ($pkColumnName == null ? 43 : $pkColumnName.hashCode());
            Object $pkColumnVal = this.getPkColumnVal();
            result = result * 59 + ($pkColumnVal == null ? 43 : $pkColumnVal.hashCode());
            List<DataColumnChangeResult> $originalColumnDatas = this.getOriginalColumnDatas();
            result = result * 59 + ($originalColumnDatas == null ? 43 : ((Object)$originalColumnDatas).hashCode());
            List<DataColumnChangeResult> $updatedColumns = this.getUpdatedColumns();
            result = result * 59 + ($updatedColumns == null ? 43 : ((Object)$updatedColumns).hashCode());
            return result;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataChangedRecord(pkColumnName=" + this.getPkColumnName() + ", pkColumnVal=" + this.getPkColumnVal() + ", originalColumnDatas=" + this.getOriginalColumnDatas() + ", updatedColumns=" + this.getUpdatedColumns() + ")";
        }
    }

    public static class DataColumnChangeResult {
        private String columnName;
        private Object originalValue;
        private Object updateValue;

        public boolean isDataChanged(Object updateValue) {
            Comparable original;
            if (Objects.equals(this.originalValue, updateValue)) {
                return false;
            }
            if (this.originalValue instanceof Clob) {
                String originalStr = DataColumnChangeResult.convertClob((Clob)this.originalValue);
                this.setOriginalValue(originalStr);
                return !originalStr.equals(updateValue);
            }
            if (this.originalValue instanceof Comparable && (original = (Comparable)this.originalValue).getClass().isInstance(updateValue)) {
                Comparable update = (Comparable)updateValue;
                return original.compareTo(update) != 0;
            }
            return true;
        }

        public static String convertClob(Clob clobObj) {
            try {
                return clobObj.getSubString(0L, (int)clobObj.length());
            }
            catch (Exception e) {
                String string;
                block11: {
                    Reader is = clobObj.getCharacterStream();
                    try {
                        int readChars;
                        char[] chars = new char[64];
                        StringBuilder sb = new StringBuilder();
                        while ((readChars = is.read(chars)) != -1) {
                            sb.append(chars, 0, readChars);
                        }
                        string = sb.toString();
                        if (is == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e2) {
                            return "unknown clobObj";
                        }
                    }
                    is.close();
                }
                return string;
            }
        }

        public static DataColumnChangeResult constrcutByUpdateVal(String columnName, Object updateValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setUpdateValue(updateValue);
            return res;
        }

        public static DataColumnChangeResult constrcutByOriginalVal(String columnName, Object originalValue) {
            DataColumnChangeResult res = new DataColumnChangeResult();
            res.setColumnName(columnName);
            res.setOriginalValue(originalValue);
            return res;
        }

        public String generateDataStr() {
            StringBuilder sb = new StringBuilder();
            sb.append("\"").append(this.columnName).append("\"").append(":").append("\"").append(this.convertDoubleQuotes(this.originalValue)).append("->").append(this.convertDoubleQuotes(this.updateValue)).append("\"").append(",");
            return sb.toString();
        }

        public String convertDoubleQuotes(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString().replace("\"", "\\\"");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Object getOriginalValue() {
            return this.originalValue;
        }

        public Object getUpdateValue() {
            return this.updateValue;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setOriginalValue(Object originalValue) {
            this.originalValue = originalValue;
        }

        public void setUpdateValue(Object updateValue) {
            this.updateValue = updateValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataColumnChangeResult)) {
                return false;
            }
            DataColumnChangeResult other = (DataColumnChangeResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            Object this$originalValue = this.getOriginalValue();
            Object other$originalValue = other.getOriginalValue();
            if (this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue)) {
                return false;
            }
            Object this$updateValue = this.getUpdateValue();
            Object other$updateValue = other.getUpdateValue();
            return !(this$updateValue == null ? other$updateValue != null : !this$updateValue.equals(other$updateValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataColumnChangeResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            Object $originalValue = this.getOriginalValue();
            result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
            Object $updateValue = this.getUpdateValue();
            result = result * 59 + ($updateValue == null ? 43 : $updateValue.hashCode());
            return result;
        }

        public String toString() {
            return "DataChangeRecorderInnerInterceptor.DataColumnChangeResult(columnName=" + this.getColumnName() + ", originalValue=" + this.getOriginalValue() + ", updateValue=" + this.getUpdateValue() + ")";
        }
    }
}

