/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.client.impl;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalMessageDeserializer;
import com.alibaba.otter.canal.client.impl.running.ClientRunningData;
import com.alibaba.otter.canal.client.impl.running.ClientRunningListener;
import com.alibaba.otter.canal.client.impl.running.ClientRunningMonitor;
import com.alibaba.otter.canal.common.utils.AddressUtils;
import com.alibaba.otter.canal.common.utils.BooleanMutex;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.SecurityUtil;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCanalConnector
implements CanalConnector {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCanalConnector.class);
    private SocketAddress address;
    private String username;
    private String password;
    private int soTimeout = 60000;
    private int idleTimeout = 3600000;
    private String filter;
    private final ByteBuffer readHeader = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
    private final ByteBuffer writeHeader = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
    private SocketChannel channel;
    private ReadableByteChannel readableChannel;
    private WritableByteChannel writableChannel;
    private List<CanalPacket.Compression> supportedCompressions = new ArrayList<CanalPacket.Compression>();
    private ClientIdentity clientIdentity;
    private ClientRunningMonitor runningMonitor;
    private ZkClientx zkClientx;
    private BooleanMutex mutex = new BooleanMutex(Boolean.valueOf(false));
    private volatile boolean connected = false;
    private boolean rollbackOnConnect = true;
    private boolean rollbackOnDisConnect = false;
    private boolean lazyParseEntry = false;
    private Object readDataLock = new Object();
    private Object writeDataLock = new Object();
    private volatile boolean running = false;

    public SimpleCanalConnector(SocketAddress address, String username, String password, String destination) {
        this(address, username, password, destination, 60000, 3600000);
    }

    public SimpleCanalConnector(SocketAddress address, String username, String password, String destination, int soTimeout) {
        this(address, username, password, destination, soTimeout, 3600000);
    }

    public SimpleCanalConnector(SocketAddress address, String username, String password, String destination, int soTimeout, int idleTimeout) {
        this.address = address;
        this.username = username;
        this.password = password;
        this.soTimeout = soTimeout;
        this.idleTimeout = idleTimeout;
        this.clientIdentity = new ClientIdentity(destination, 1001);
    }

    @Override
    public void connect() throws CanalClientException {
        if (this.connected) {
            return;
        }
        if (this.runningMonitor != null) {
            if (!this.runningMonitor.isStart()) {
                this.runningMonitor.start();
            }
        } else {
            this.waitClientRunning();
            if (!this.running) {
                return;
            }
            this.doConnect();
            if (this.filter != null) {
                this.subscribe(this.filter);
            }
            if (this.rollbackOnConnect) {
                this.rollback();
            }
        }
        this.connected = true;
    }

    @Override
    public void disconnect() throws CanalClientException {
        if (this.rollbackOnDisConnect && this.channel.isConnected()) {
            this.rollback();
        }
        this.connected = false;
        if (this.runningMonitor != null) {
            if (this.runningMonitor.isStart()) {
                this.runningMonitor.stop();
            }
        } else {
            this.doDisconnect();
        }
    }

    private InetSocketAddress doConnect() throws CanalClientException {
        try {
            this.channel = SocketChannel.open();
            this.channel.socket().setSoTimeout(this.soTimeout);
            SocketAddress address = this.getAddress();
            if (address == null) {
                address = this.getNextAddress();
            }
            this.channel.connect(address);
            this.readableChannel = Channels.newChannel(this.channel.socket().getInputStream());
            this.writableChannel = Channels.newChannel(this.channel.socket().getOutputStream());
            CanalPacket.Packet p = CanalPacket.Packet.parseFrom((byte[])this.readNextPacket());
            if (p.getVersion() != 1) {
                throw new CanalClientException("unsupported version at this client.");
            }
            if (p.getType() != CanalPacket.PacketType.HANDSHAKE) {
                throw new CanalClientException("expect handshake but found other type.");
            }
            CanalPacket.Handshake handshake = CanalPacket.Handshake.parseFrom((ByteString)p.getBody());
            this.supportedCompressions.add(handshake.getSupportedCompressions());
            ByteString seed = handshake.getSeeds();
            String newPasswd = this.password;
            if (this.password != null) {
                newPasswd = SecurityUtil.byte2HexStr((byte[])SecurityUtil.scramble411((byte[])this.password.getBytes(), (byte[])seed.toByteArray()));
            }
            CanalPacket.ClientAuth ca = CanalPacket.ClientAuth.newBuilder().setUsername(this.username != null ? this.username : "").setPassword(ByteString.copyFromUtf8((String)(newPasswd != null ? newPasswd : ""))).setNetReadTimeout(this.idleTimeout).setNetWriteTimeout(this.idleTimeout).build();
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.CLIENTAUTHENTICATION).setBody(ca.toByteString()).build().toByteArray());
            CanalPacket.Packet ack = CanalPacket.Packet.parseFrom((byte[])this.readNextPacket());
            if (ack.getType() != CanalPacket.PacketType.ACK) {
                throw new CanalClientException("unexpected packet type when ack is expected");
            }
            CanalPacket.Ack ackBody = CanalPacket.Ack.parseFrom((ByteString)ack.getBody());
            if (ackBody.getErrorCode() > 0) {
                throw new CanalClientException("something goes wrong when doing authentication: " + ackBody.getErrorMessage());
            }
            this.connected = true;
            return new InetSocketAddress(this.channel.socket().getLocalAddress(), this.channel.socket().getLocalPort());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    private void doDisconnect() throws CanalClientException {
        if (this.readableChannel != null) {
            this.quietlyClose(this.readableChannel);
            this.readableChannel = null;
        }
        if (this.writableChannel != null) {
            this.quietlyClose(this.writableChannel);
            this.writableChannel = null;
        }
        if (this.channel != null) {
            this.quietlyClose(this.channel);
            this.channel = null;
        }
    }

    private void quietlyClose(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            logger.warn("exception on closing channel:{} \n {}", (Object)channel, (Object)e);
        }
    }

    @Override
    public void subscribe() throws CanalClientException {
        this.subscribe("");
    }

    @Override
    public void subscribe(String filter) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        try {
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.SUBSCRIPTION).setBody(CanalPacket.Sub.newBuilder().setDestination(this.clientIdentity.getDestination()).setClientId(String.valueOf(this.clientIdentity.getClientId())).setFilter(filter != null ? filter : "").build().toByteString()).build().toByteArray());
            CanalPacket.Packet p = CanalPacket.Packet.parseFrom((byte[])this.readNextPacket());
            CanalPacket.Ack ack = CanalPacket.Ack.parseFrom((ByteString)p.getBody());
            if (ack.getErrorCode() > 0) {
                throw new CanalClientException("failed to subscribe with reason: " + ack.getErrorMessage());
            }
            this.clientIdentity.setFilter(filter);
        }
        catch (IOException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    @Override
    public void unsubscribe() throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        try {
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.UNSUBSCRIPTION).setBody(CanalPacket.Unsub.newBuilder().setDestination(this.clientIdentity.getDestination()).setClientId(String.valueOf(this.clientIdentity.getClientId())).build().toByteString()).build().toByteArray());
            CanalPacket.Packet p = CanalPacket.Packet.parseFrom((byte[])this.readNextPacket());
            CanalPacket.Ack ack = CanalPacket.Ack.parseFrom((ByteString)p.getBody());
            if (ack.getErrorCode() > 0) {
                throw new CanalClientException("failed to unSubscribe with reason: " + ack.getErrorMessage());
            }
        }
        catch (IOException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    @Override
    public Message get(int batchSize) throws CanalClientException {
        return this.get(batchSize, null, null);
    }

    @Override
    public Message get(int batchSize, Long timeout, TimeUnit unit) throws CanalClientException {
        Message message = this.getWithoutAck(batchSize, timeout, unit);
        this.ack(message.getId());
        return message;
    }

    @Override
    public Message getWithoutAck(int batchSize) throws CanalClientException {
        return this.getWithoutAck(batchSize, null, null);
    }

    @Override
    public Message getWithoutAck(int batchSize, Long timeout, TimeUnit unit) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return null;
        }
        try {
            long time;
            int size = batchSize <= 0 ? 1000 : batchSize;
            long l = time = timeout == null || timeout < 0L ? -1L : timeout;
            if (unit == null) {
                unit = TimeUnit.MILLISECONDS;
            }
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.GET).setBody(CanalPacket.Get.newBuilder().setAutoAck(false).setDestination(this.clientIdentity.getDestination()).setClientId(String.valueOf(this.clientIdentity.getClientId())).setFetchSize(size).setTimeout(time).setUnit(unit.ordinal()).build().toByteString()).build().toByteArray());
            return this.receiveMessages();
        }
        catch (IOException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    private Message receiveMessages() throws IOException {
        byte[] data = this.readNextPacket();
        return CanalMessageDeserializer.deserializer(data, this.lazyParseEntry);
    }

    @Override
    public void ack(long batchId) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        CanalPacket.ClientAck ca = CanalPacket.ClientAck.newBuilder().setDestination(this.clientIdentity.getDestination()).setClientId(String.valueOf(this.clientIdentity.getClientId())).setBatchId(batchId).build();
        try {
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.CLIENTACK).setBody(ca.toByteString()).build().toByteArray());
        }
        catch (IOException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    @Override
    public void rollback(long batchId) throws CanalClientException {
        this.waitClientRunning();
        CanalPacket.ClientRollback ca = CanalPacket.ClientRollback.newBuilder().setDestination(this.clientIdentity.getDestination()).setClientId(String.valueOf(this.clientIdentity.getClientId())).setBatchId(batchId).build();
        try {
            this.writeWithHeader(CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.CLIENTROLLBACK).setBody(ca.toByteString()).build().toByteArray());
        }
        catch (IOException e) {
            throw new CanalClientException((Throwable)e);
        }
    }

    @Override
    public void rollback() throws CanalClientException {
        this.waitClientRunning();
        this.rollback(0L);
    }

    private void writeWithHeader(byte[] body) throws IOException {
        this.writeWithHeader(this.writableChannel, body);
    }

    private byte[] readNextPacket() throws IOException {
        return this.readNextPacket(this.readableChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWithHeader(WritableByteChannel channel, byte[] body) throws IOException {
        Object object = this.writeDataLock;
        synchronized (object) {
            this.writeHeader.clear();
            this.writeHeader.putInt(body.length);
            this.writeHeader.flip();
            channel.write(this.writeHeader);
            channel.write(ByteBuffer.wrap(body));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readNextPacket(ReadableByteChannel channel) throws IOException {
        Object object = this.readDataLock;
        synchronized (object) {
            this.readHeader.clear();
            this.read(channel, this.readHeader);
            int bodyLen = this.readHeader.getInt(0);
            ByteBuffer bodyBuf = ByteBuffer.allocate(bodyLen).order(ByteOrder.BIG_ENDIAN);
            this.read(channel, bodyBuf);
            return bodyBuf.array();
        }
    }

    private void read(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            int r = channel.read(buffer);
            if (r != -1) continue;
            throw new IOException("end of stream when reading header");
        }
    }

    private synchronized void initClientRunningMonitor(ClientIdentity clientIdentity) {
        if (this.zkClientx != null && clientIdentity != null && this.runningMonitor == null) {
            ClientRunningData clientData = new ClientRunningData();
            clientData.setClientId(clientIdentity.getClientId());
            clientData.setAddress(AddressUtils.getHostIp());
            this.runningMonitor = new ClientRunningMonitor();
            this.runningMonitor.setDestination(clientIdentity.getDestination());
            this.runningMonitor.setZkClient(this.zkClientx);
            this.runningMonitor.setClientData(clientData);
            this.runningMonitor.setListener(new ClientRunningListener(){

                @Override
                public InetSocketAddress processActiveEnter() {
                    InetSocketAddress address = SimpleCanalConnector.this.doConnect();
                    SimpleCanalConnector.this.mutex.set(Boolean.valueOf(true));
                    if (SimpleCanalConnector.this.filter != null) {
                        SimpleCanalConnector.this.subscribe(SimpleCanalConnector.this.filter);
                    }
                    if (SimpleCanalConnector.this.rollbackOnConnect) {
                        SimpleCanalConnector.this.rollback();
                    }
                    return address;
                }

                @Override
                public void processActiveExit() {
                    SimpleCanalConnector.this.mutex.set(Boolean.valueOf(false));
                    SimpleCanalConnector.this.doDisconnect();
                }
            });
        }
    }

    private void waitClientRunning() {
        try {
            if (this.zkClientx != null) {
                if (!this.connected) {
                    throw new CanalClientException("should connect first");
                }
                this.running = true;
                this.mutex.get();
            } else {
                this.running = true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CanalClientException((Throwable)e);
        }
    }

    @Override
    public boolean checkValid() {
        if (this.zkClientx != null) {
            return this.mutex.state();
        }
        return true;
    }

    public SocketAddress getNextAddress() {
        return null;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setZkClientx(ZkClientx zkClientx) {
        this.zkClientx = zkClientx;
        this.initClientRunningMonitor(this.clientIdentity);
    }

    public void setRollbackOnConnect(boolean rollbackOnConnect) {
        this.rollbackOnConnect = rollbackOnConnect;
    }

    public void setRollbackOnDisConnect(boolean rollbackOnDisConnect) {
        this.rollbackOnDisConnect = rollbackOnDisConnect;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isLazyParseEntry() {
        return this.lazyParseEntry;
    }

    public void setLazyParseEntry(boolean lazyParseEntry) {
        this.lazyParseEntry = lazyParseEntry;
    }

    public void stopRunning() {
        if (this.running) {
            this.running = false;
            if (!this.mutex.state()) {
                this.mutex.set(Boolean.valueOf(true));
            }
        }
    }
}

