/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.JSONReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.TimeZone;

public class JSONReader
implements Closeable {
    private final Reader input;
    private com.alibaba.fastjson2.JSONReader raw;

    public JSONReader(Reader reader) {
        this(reader, new Feature[0]);
    }

    public JSONReader(Reader input, Feature ... features) {
        this.raw = com.alibaba.fastjson2.JSONReader.of((Reader)input);
        this.input = input;
        JSONReader.Context context = this.raw.getContext();
        for (Feature feature : features) {
            if (feature != Feature.SupportArrayToBean) continue;
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
        }
    }

    public void setLocale(Locale locale) {
        this.raw.getContext().setLocale(locale);
    }

    public void setTimzeZone(TimeZone timezone) {
        this.raw.getContext().setTimeZone(timezone);
    }

    public <T> T readObject(Class<T> type) {
        try {
            return (T)this.raw.read(type);
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            throw new JSONException(ex.getMessage(), ex.getCause());
        }
    }

    public Locale getLocal() {
        return this.raw.getContext().getLocale();
    }

    public TimeZone getTimeZone() {
        return this.raw.getContext().getTimeZone();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

