/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql;

import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapter;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.esql.ElasticsearchEsqlAsyncClient;
import co.elastic.clients.elasticsearch.esql.ElasticsearchEsqlClient;
import co.elastic.clients.elasticsearch.esql.QueryRequest;
import co.elastic.clients.elasticsearch.esql.query.EsqlFormat;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class EsqlHelper {
    public static <T> T query(ElasticsearchEsqlClient client, EsqlAdapter<T> adapter, String query, Object ... params) throws IOException {
        QueryRequest request = EsqlHelper.buildRequest(adapter, query, params);
        BinaryResponse response = client.query(request);
        return adapter.deserialize(client, request, response);
    }

    public static <T> T query(ElasticsearchEsqlClient client, EsqlAdapter<T> adapter, QueryRequest request) throws IOException {
        request = EsqlHelper.buildRequest(adapter, request);
        BinaryResponse response = client.query(request);
        return adapter.deserialize(client, request, response);
    }

    public static <T> CompletableFuture<T> queryAsync(ElasticsearchEsqlAsyncClient client, EsqlAdapter<T> adapter, String query, Object ... params) {
        return EsqlHelper.doQueryAsync(client, adapter, EsqlHelper.buildRequest(adapter, query, params));
    }

    public static <T> CompletableFuture<T> queryAsync(ElasticsearchEsqlAsyncClient client, EsqlAdapter<T> adapter, QueryRequest request) {
        return EsqlHelper.doQueryAsync(client, adapter, EsqlHelper.buildRequest(adapter, request));
    }

    private static <T> CompletableFuture<T> doQueryAsync(ElasticsearchEsqlAsyncClient client, EsqlAdapter<T> adapter, QueryRequest request) {
        return client.query(request).thenApply(r -> {
            try {
                return adapter.deserialize(client, request, (BinaryResponse)r);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static QueryRequest buildRequest(EsqlAdapter<?> adapter, String query, Object ... params) {
        return QueryRequest.of(esql -> esql.format((EsqlFormat)EsqlFormat._DESERIALIZER.parse(adapter.format())).columnar(adapter.columnar()).query(query).params(EsqlHelper.asFieldValues(params)));
    }

    private static QueryRequest buildRequest(EsqlAdapter<?> adapter, QueryRequest request) {
        return QueryRequest.of(q -> q.format((EsqlFormat)EsqlFormat._DESERIALIZER.parse(adapter.format())).columnar(adapter.columnar()).delimiter(request.delimiter()).filter(request.filter()).locale(request.locale()).params(request.params()).query(request.query()));
    }

    private static List<FieldValue> asFieldValues(Object ... objects) {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>(objects.length);
        for (Object object : objects) {
            result.add(FieldValue.of(JsonData.of(object)));
        }
        return result;
    }
}

