/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.expression.engine;

import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.expression.ExpressionEngine;
import cn.hutool.extra.expression.ExpressionException;
import cn.hutool.log.StaticLog;

public class ExpressionFactory {
    public static ExpressionEngine get() {
        return (ExpressionEngine)Singleton.get((String)ExpressionEngine.class.getName(), ExpressionFactory::create);
    }

    public static ExpressionEngine create() {
        ExpressionEngine engine = ExpressionFactory.doCreate();
        StaticLog.debug((String)"Use [{}] Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static ExpressionEngine doCreate() {
        ExpressionEngine engine = (ExpressionEngine)ServiceLoaderUtil.loadFirstAvailable(ExpressionEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new ExpressionException("No expression jar found ! Please add one of it to your project !");
    }
}

