/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.util.Date;

public class JWTValidator {
    private final JWT jwt;

    public static JWTValidator of(String token) {
        return new JWTValidator(JWT.of(token));
    }

    public static JWTValidator of(JWT jwt) {
        return new JWTValidator(jwt);
    }

    public JWTValidator(JWT jwt) {
        this.jwt = jwt;
    }

    public JWTValidator validateAlgorithm() throws ValidateException {
        return this.validateAlgorithm(null);
    }

    public JWTValidator validateAlgorithm(JWTSigner signer) throws ValidateException {
        JWTValidator.validateAlgorithm(this.jwt, signer);
        return this;
    }

    public JWTValidator validateDate(Date dateToCheck) throws ValidateException {
        JWTValidator.validateDate(this.jwt.getPayload(), dateToCheck);
        return this;
    }

    private static void validateAlgorithm(JWT jwt, JWTSigner signer) throws ValidateException {
        String algorithmId = jwt.getAlgorithm();
        if (null == signer) {
            signer = jwt.getSigner();
        }
        if (StrUtil.isEmpty(algorithmId)) {
            if (null == signer || signer instanceof NoneJWTSigner) {
                return;
            }
            throw new ValidateException("No algorithm defined in header!");
        }
        if (null == signer) {
            throw new IllegalArgumentException("No Signer for validate algorithm!");
        }
        String algorithmIdInSigner = signer.getAlgorithmId();
        if (!StrUtil.equals(algorithmId, algorithmIdInSigner)) {
            throw new ValidateException("Algorithm [{}] defined in header doesn't match to [{}]!", algorithmId, algorithmIdInSigner);
        }
        if (!jwt.verify(signer)) {
            throw new ValidateException("Signature verification failed!");
        }
    }

    private static void validateDate(JWTPayload payload, Date dateToCheck) throws ValidateException {
        Date notBefore;
        if (null == dateToCheck) {
            dateToCheck = DateUtil.date();
        }
        if (null != (notBefore = payload.getClaimsJson().getDate("nbf")) && dateToCheck.before(notBefore)) {
            throw new ValidateException("Current date [{}] is before 'nbf' [{}]", dateToCheck, DateUtil.date(notBefore));
        }
        Date expiresAt = payload.getClaimsJson().getDate("exp");
        if (null != expiresAt && dateToCheck.after(expiresAt)) {
            throw new ValidateException("Current date [{}] is after 'exp' [{}]", dateToCheck, DateUtil.date(expiresAt));
        }
        Date issueAt = payload.getClaimsJson().getDate("iat");
        if (null != issueAt && dateToCheck.before(issueAt)) {
            throw new ValidateException("Current date [{}] is before 'iat' [{}]", dateToCheck, DateUtil.date(issueAt));
        }
    }
}

