/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.sql;

import java.io.Serializable;
import java.util.Arrays;

public class SelectRequest
implements Serializable {
    private static final long serialVersionUID = 2212052574976898602L;
    private byte queryType;
    private String sql;
    private Object[] args;
    private String className;

    public byte getQueryType() {
        return this.queryType;
    }

    public void setQueryType(byte queryType) {
        this.queryType = queryType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return "SelectRequest{queryType=" + this.queryType + ", sql='" + this.sql + '\'' + ", args=" + Arrays.toString(this.args) + ", className='" + this.className + '\'' + '}';
    }

    public static SelectRequestBuilder builder() {
        return new SelectRequestBuilder();
    }

    public static final class SelectRequestBuilder {
        private byte queryType;
        private String sql;
        private Object[] args;
        private String className = null;

        private SelectRequestBuilder() {
        }

        public SelectRequestBuilder queryType(byte queryType) {
            this.queryType = queryType;
            return this;
        }

        public SelectRequestBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public SelectRequestBuilder args(Object[] args) {
            this.args = args;
            return this;
        }

        public SelectRequestBuilder className(String className) {
            this.className = className;
            return this;
        }

        public SelectRequest build() {
            SelectRequest request = new SelectRequest();
            request.setQueryType(this.queryType);
            request.setSql(this.sql);
            request.setArgs(this.args);
            request.setClassName(this.className);
            return request;
        }
    }
}

