/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.datasource;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.datasource.DataSourcePoolProperties;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class LocalDataSourceServiceImpl
implements DataSourceService {
    private final String jdbcDriverName = "org.apache.derby.jdbc.EmbeddedDriver";
    private final String userName = "nacos";
    private final String password = "nacos";
    private final String derbyBaseDir = "data" + File.separator + "derby-data";
    private final String derbyShutdownErrMsg = "Derby system shutdown.";
    private volatile JdbcTemplate jt;
    private volatile TransactionTemplate tjt;
    private boolean initialize = false;
    private boolean jdbcTemplateInit = false;
    private String healthStatus = "UP";

    @Override
    @PostConstruct
    public synchronized void init() throws Exception {
        if (PropertyUtil.isUseExternalDB()) {
            return;
        }
        if (!this.initialize) {
            LogUtil.DEFAULT_LOG.info("use local db service for init");
            String jdbcUrl = "jdbc:derby:" + Paths.get(EnvUtil.getNacosHome(), this.derbyBaseDir).toString() + ";create=true";
            this.initialize(jdbcUrl);
            this.initialize = true;
        }
    }

    @Override
    public synchronized void reload() {
        DataSource ds = this.jt.getDataSource();
        if (ds == null) {
            throw new RuntimeException("datasource is null");
        }
        try {
            this.execute(ds.getConnection(), "META-INF/derby-schema.sql");
        }
        catch (Exception e) {
            if (LogUtil.DEFAULT_LOG.isErrorEnabled()) {
                LogUtil.DEFAULT_LOG.error(e.getMessage(), (Throwable)e);
            }
            throw new NacosRuntimeException(500, "load derby-schema.sql error.", (Throwable)e);
        }
    }

    public DataSource getDatasource() {
        return this.jt.getDataSource();
    }

    public void cleanAndReopenDerby() throws Exception {
        this.doDerbyClean();
        String jdbcUrl = "jdbc:derby:" + Paths.get(EnvUtil.getNacosHome(), this.derbyBaseDir).toString() + ";create=true";
        this.initialize(jdbcUrl);
    }

    public void restoreDerby(String jdbcUrl, Callable<Void> callable) throws Exception {
        this.doDerbyClean();
        callable.call();
        this.initialize(jdbcUrl);
    }

    private void doDerbyClean() throws Exception {
        block2: {
            LogUtil.DEFAULT_LOG.warn("use local db service for reopenDerby");
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (Exception e) {
                if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Derby system shutdown.")) break block2;
                throw e;
            }
        }
        DiskUtils.deleteDirectory((String)Paths.get(EnvUtil.getNacosHome(), this.derbyBaseDir).toString());
    }

    private synchronized void initialize(String jdbcUrl) {
        DataSourcePoolProperties poolProperties = DataSourcePoolProperties.build((Environment)EnvUtil.getEnvironment());
        poolProperties.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
        poolProperties.setJdbcUrl(jdbcUrl);
        poolProperties.setUsername("nacos");
        poolProperties.setPassword("nacos");
        HikariDataSource ds = poolProperties.getDataSource();
        DataSourceTransactionManager tm = new DataSourceTransactionManager();
        tm.setDataSource((DataSource)ds);
        if (this.jdbcTemplateInit) {
            this.jt.setDataSource((DataSource)ds);
            this.tjt.setTransactionManager((PlatformTransactionManager)tm);
        } else {
            this.jt = new JdbcTemplate();
            this.jt.setMaxRows(50000);
            this.jt.setQueryTimeout(5000);
            this.jt.setDataSource((DataSource)ds);
            this.tjt = new TransactionTemplate((PlatformTransactionManager)tm);
            this.tjt.setTimeout(5000);
            this.jdbcTemplateInit = true;
        }
        this.reload();
    }

    @Override
    public boolean checkMasterWritable() {
        return true;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jt;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.tjt;
    }

    @Override
    public String getCurrentDbUrl() {
        return "jdbc:derby:" + EnvUtil.getNacosHome() + File.separator + this.derbyBaseDir + ";create=true";
    }

    @Override
    public String getHealth() {
        return this.healthStatus;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    private List<String> loadSql(String sqlFile) throws Exception {
        ArrayList<String> arrayList;
        ArrayList<String> sqlList = new ArrayList<String>();
        InputStream sqlFileIn = null;
        try {
            File file = new File(EnvUtil.getNacosHome() + File.separator + "conf" + File.separator + "derby-schema.sql");
            if (StringUtils.isBlank((CharSequence)EnvUtil.getNacosHome()) || !file.exists()) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL url = classLoader.getResource(sqlFile);
                sqlFileIn = url.openStream();
            } else {
                sqlFileIn = new FileInputStream(file);
            }
            StringBuilder sqlSb = new StringBuilder();
            byte[] buff = new byte[1024];
            int byteRead = 0;
            while ((byteRead = sqlFileIn.read(buff)) != -1) {
                sqlSb.append(new String(buff, 0, byteRead, "UTF-8"));
            }
            String[] sqlArr = sqlSb.toString().split(";");
            for (int i = 0; i < sqlArr.length; ++i) {
                String sql = sqlArr[i].replaceAll("--.*", "").trim();
                if (!StringUtils.isNotEmpty((String)sql)) continue;
                sqlList.add(sql);
            }
            arrayList = sqlList;
        }
        catch (Exception ex) {
            try {
                throw new Exception(ex.getMessage());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(sqlFileIn);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((Closeable)sqlFileIn);
        return arrayList;
    }

    private void execute(Connection conn, String sqlFile) throws Exception {
        try (Statement stmt = conn.createStatement();){
            List<String> sqlList = this.loadSql(sqlFile);
            for (String sql : sqlList) {
                try {
                    stmt.execute(sql);
                }
                catch (Exception e) {
                    LogUtil.DEFAULT_LOG.warn(e.getMessage());
                }
            }
        }
    }
}

