/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.datasource;

import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.ExternalDataSourceServiceImpl;
import com.alibaba.nacos.config.server.service.datasource.LocalDataSourceServiceImpl;
import com.alibaba.nacos.config.server.utils.PropertyUtil;

public class DynamicDataSource {
    private DataSourceService localDataSourceService = null;
    private DataSourceService basicDataSourceService = null;
    private static final DynamicDataSource INSTANCE = new DynamicDataSource();

    private DynamicDataSource() {
    }

    public static DynamicDataSource getInstance() {
        return INSTANCE;
    }

    public synchronized DataSourceService getDataSource() {
        try {
            if (PropertyUtil.isEmbeddedStorage()) {
                if (this.localDataSourceService == null) {
                    this.localDataSourceService = new LocalDataSourceServiceImpl();
                    this.localDataSourceService.init();
                }
                return this.localDataSourceService;
            }
            if (this.basicDataSourceService == null) {
                this.basicDataSourceService = new ExternalDataSourceServiceImpl();
                this.basicDataSourceService.init();
            }
            return this.basicDataSourceService;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

