/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.capacity.GroupCapacity;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;

@Service
public class GroupCapacityPersistService {
    static final String CLUSTER = "";
    private static final GroupCapacityRowMapper GROUP_CAPACITY_ROW_MAPPER = new GroupCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    private DataSourceService dataSourceService;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
    }

    public GroupCapacity getGroupCapacity(String groupId) {
        String sql = "SELECT id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, group_id FROM group_capacity WHERE group_id=?";
        List list = this.jdbcTemplate.query(sql, new Object[]{groupId}, (RowMapper)GROUP_CAPACITY_ROW_MAPPER);
        if (list.isEmpty()) {
            return null;
        }
        return (GroupCapacity)list.get(0);
    }

    public Capacity getClusterCapacity() {
        return this.getGroupCapacity(CLUSTER);
    }

    public boolean insertGroupCapacity(GroupCapacity capacity) {
        String sql = CLUSTER.equals(capacity.getGroup()) ? "INSERT INTO group_capacity (group_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info;" : "INSERT INTO group_capacity (group_id, quota, `usage`, `max_size`, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE group_id=? AND tenant_id = '';";
        return this.insertGroupCapacity(sql, capacity);
    }

    private boolean insertGroupCapacity(String sql, GroupCapacity capacity) {
        try {
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                String group = capacity.getGroup();
                ps.setString(1, group);
                ps.setInt(2, capacity.getQuota());
                ps.setInt(3, capacity.getMaxSize());
                ps.setInt(4, capacity.getMaxAggrCount());
                ps.setInt(5, capacity.getMaxAggrSize());
                ps.setTimestamp(6, capacity.getGmtCreate());
                ps.setTimestamp(7, capacity.getGmtModified());
                if (!CLUSTER.equals(group)) {
                    ps.setString(8, group);
                }
                return ps;
            };
            this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
            return generatedKeyHolder.getKey() != null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public int getClusterUsage() {
        Capacity clusterCapacity = this.getClusterCapacity();
        if (clusterCapacity != null) {
            return clusterCapacity.getUsage();
        }
        String sql = "SELECT count(*) FROM config_info";
        Integer result = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    public boolean incrementUsageWithDefaultQuotaLimit(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ? AND `usage` < ? AND quota = 0";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup(), groupCapacity.getQuota()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ? AND `usage` < quota AND quota != 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` + 1, gmt_modified = ? WHERE group_id = ?";
        try {
            int affectRow = this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()});
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(GroupCapacity groupCapacity) {
        String sql = "UPDATE group_capacity SET `usage` = `usage` - 1, gmt_modified = ? WHERE group_id = ? AND `usage` > 0";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{groupCapacity.getGmtModified(), groupCapacity.getGroup()}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        List argList = CollectionUtils.list((Object[])new Object[0]);
        StringBuilder sql = new StringBuilder("update group_capacity set");
        if (quota != null) {
            sql.append(" quota = ?,");
            argList.add(quota);
        }
        if (maxSize != null) {
            sql.append(" max_size = ?,");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            sql.append(" max_aggr_count = ?,");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            sql.append(" max_aggr_size = ?,");
            argList.add(maxAggrSize);
        }
        sql.append(" gmt_modified = ?");
        argList.add(TimeUtils.getCurrentTime());
        sql.append(" WHERE group_id = ?");
        argList.add(group);
        try {
            return this.jdbcTemplate.update(sql.toString(), argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String group, Integer quota) {
        return this.updateGroupCapacity(group, quota, null, null, null);
    }

    public boolean updateMaxSize(String group, Integer maxSize) {
        return this.updateGroupCapacity(group, null, maxSize, null, null);
    }

    public boolean correctUsage(String group, Timestamp gmtModified) {
        if (CLUSTER.equals(group)) {
            String sql = "UPDATE group_capacity SET `usage` = (SELECT count(*) FROM config_info), gmt_modified = ? WHERE group_id = ?";
            try {
                return this.jdbcTemplate.update(sql, new Object[]{gmtModified, group}) == 1;
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
                throw e;
            }
        }
        String sql = "UPDATE group_capacity SET `usage` = (SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id = ''), gmt_modified = ? WHERE group_id = ?";
        try {
            return this.jdbcTemplate.update(sql, new Object[]{group, gmtModified, group}) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<GroupCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        String sql = "SELECT id, group_id FROM group_capacity WHERE id>? LIMIT ?";
        if (PropertyUtil.isEmbeddedStorage()) {
            sql = "SELECT id, group_id FROM group_capacity WHERE id>? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";
        }
        try {
            return this.jdbcTemplate.query(sql, new Object[]{lastId, pageSize}, (RowMapper)new RowMapper<GroupCapacity>(){

                public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
                    GroupCapacity groupCapacity = new GroupCapacity();
                    groupCapacity.setId(rs.getLong("id"));
                    groupCapacity.setGroup(rs.getString("group_id"));
                    return groupCapacity;
                }
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteGroupCapacity(String group) {
        try {
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement("DELETE FROM group_capacity WHERE group_id = ?;");
                ps.setString(1, group);
                return ps;
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    private static final class GroupCapacityRowMapper
    implements RowMapper<GroupCapacity> {
        private GroupCapacityRowMapper() {
        }

        public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            GroupCapacity groupCapacity = new GroupCapacity();
            groupCapacity.setId(rs.getLong("id"));
            groupCapacity.setQuota(rs.getInt("quota"));
            groupCapacity.setUsage(rs.getInt("usage"));
            groupCapacity.setMaxSize(rs.getInt("max_size"));
            groupCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            groupCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            groupCapacity.setGroup(rs.getString("group_id"));
            return groupCapacity;
        }
    }
}

