/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.model.SubscriberStatus;
import com.alibaba.nacos.config.server.service.ClientRecord;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientTrackService {
    static volatile ConcurrentMap<String, ClientRecord> clientRecords = new ConcurrentHashMap<String, ClientRecord>();

    public static void trackClientMd5(String ip, Map<String, String> clientMd5Map) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.setLastTime(System.currentTimeMillis());
        record.getGroupKey2md5Map().putAll(clientMd5Map);
    }

    public static void trackClientMd5(String ip, Map<String, String> clientMd5Map, Map<String, Long> clientLastPollingTsMap) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.setLastTime(System.currentTimeMillis());
        record.getGroupKey2md5Map().putAll(clientMd5Map);
        record.getGroupKey2pollingTsMap().putAll(clientLastPollingTsMap);
    }

    public static void trackClientMd5(String ip, String groupKey, String clientMd5) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.setLastTime(System.currentTimeMillis());
        record.getGroupKey2md5Map().put(groupKey, clientMd5);
        record.getGroupKey2pollingTsMap().put(groupKey, record.getLastTime());
    }

    public static int subscribeClientCount() {
        return clientRecords.size();
    }

    public static long subscriberCount() {
        long count = 0L;
        for (ClientRecord record : clientRecords.values()) {
            count += (long)record.getGroupKey2md5Map().size();
        }
        return count;
    }

    public static Map<String, SubscriberStatus> listSubStatus(String ip) {
        HashMap<String, SubscriberStatus> status = new HashMap<String, SubscriberStatus>(100);
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        for (Map.Entry entry : record.getGroupKey2md5Map().entrySet()) {
            String groupKey = (String)entry.getKey();
            String clientMd5 = (String)entry.getValue();
            long lastPollingTs = (Long)record.getGroupKey2pollingTsMap().get(groupKey);
            boolean isUpdate = ConfigCacheService.isUptodate(groupKey, clientMd5);
            status.put(groupKey, new SubscriberStatus(groupKey, isUpdate, clientMd5, lastPollingTs));
        }
        return status;
    }

    public static Map<String, SubscriberStatus> listSubsByGroup(String groupKey) {
        HashMap<String, SubscriberStatus> subs = new HashMap<String, SubscriberStatus>(100);
        for (ClientRecord clientRec : clientRecords.values()) {
            String clientMd5 = (String)clientRec.getGroupKey2md5Map().get(groupKey);
            Long lastPollingTs = (Long)clientRec.getGroupKey2pollingTsMap().get(groupKey);
            if (null == clientMd5 || null == lastPollingTs) continue;
            Boolean isUpdate = ConfigCacheService.isUptodate(groupKey, clientMd5);
            subs.put(clientRec.getIp(), new SubscriberStatus(groupKey, isUpdate, clientMd5, lastPollingTs));
        }
        return subs;
    }

    public static Map<String, Boolean> isClientUptodate(String ip) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(100);
        for (Map.Entry entry : ClientTrackService.getClientRecord(ip).getGroupKey2md5Map().entrySet()) {
            String groupKey = (String)entry.getKey();
            String clientMd5 = (String)entry.getValue();
            Boolean isuptodate = ConfigCacheService.isUptodate(groupKey, clientMd5);
            result.put(groupKey, isuptodate);
        }
        return result;
    }

    public static Map<String, Boolean> listSubscriberByGroup(String groupKey) {
        HashMap<String, Boolean> subs = new HashMap<String, Boolean>(100);
        for (ClientRecord clientRec : clientRecords.values()) {
            String clientMd5 = (String)clientRec.getGroupKey2md5Map().get(groupKey);
            if (null == clientMd5) continue;
            Boolean isuptodate = ConfigCacheService.isUptodate(groupKey, clientMd5);
            subs.put(clientRec.getIp(), isuptodate);
        }
        return subs;
    }

    private static ClientRecord getClientRecord(String clientIp) {
        ClientRecord record = (ClientRecord)clientRecords.get(clientIp);
        if (null != record) {
            return record;
        }
        ClientRecord clientRecord = new ClientRecord(clientIp);
        clientRecords.putIfAbsent(clientIp, clientRecord);
        return clientRecord;
    }

    public static void refreshClientRecord() {
        clientRecords = new ConcurrentHashMap<String, ClientRecord>(50);
    }
}

