/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ConfigChangeListenContext {
    private ConcurrentHashMap<String, HashSet<String>> groupKeyContext = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashMap<String, String>> connectionIdContext = new ConcurrentHashMap();

    public synchronized void addListen(String groupKey, String md5, String connectionId) {
        Set listenClients = this.groupKeyContext.get(groupKey);
        if (listenClients == null) {
            this.groupKeyContext.putIfAbsent(groupKey, new HashSet());
            listenClients = this.groupKeyContext.get(groupKey);
        }
        listenClients.add(connectionId);
        HashMap<String, String> groupKeys = this.connectionIdContext.get(connectionId);
        if (groupKeys == null) {
            this.connectionIdContext.putIfAbsent(connectionId, new HashMap(16));
            groupKeys = this.connectionIdContext.get(connectionId);
        }
        groupKeys.put(groupKey, md5);
    }

    public synchronized void removeListen(String groupKey, String connectionId) {
        HashMap<String, String> groupKeys;
        Set connectionIds = this.groupKeyContext.get(groupKey);
        if (connectionIds != null) {
            connectionIds.remove(connectionId);
            if (connectionIds.isEmpty()) {
                this.groupKeyContext.remove(groupKey);
            }
        }
        if ((groupKeys = this.connectionIdContext.get(connectionId)) != null) {
            groupKeys.remove(groupKey);
        }
    }

    public synchronized Set<String> getListeners(String groupKey) {
        HashSet<String> strings = this.groupKeyContext.get(groupKey);
        if (CollectionUtils.isNotEmpty(strings)) {
            HashSet<String> listenConnections = new HashSet<String>();
            this.safeCopy(strings, listenConnections);
            return listenConnections;
        }
        return null;
    }

    private void safeCopy(Collection src, Collection dest) {
        Iterator iterator = src.iterator();
        while (iterator.hasNext()) {
            dest.add(iterator.next());
        }
    }

    public synchronized void clearContextForConnectionId(String connectionId) {
        Map<String, String> listenKeys = this.getListenKeys(connectionId);
        if (listenKeys == null) {
            this.connectionIdContext.remove(connectionId);
            return;
        }
        for (Map.Entry<String, String> groupKey : listenKeys.entrySet()) {
            Set connectionIds = this.groupKeyContext.get(groupKey.getKey());
            if (CollectionUtils.isNotEmpty((Collection)connectionIds)) {
                connectionIds.remove(connectionId);
                continue;
            }
            this.groupKeyContext.remove(groupKey.getKey());
        }
        this.connectionIdContext.remove(connectionId);
    }

    public synchronized Map<String, String> getListenKeys(String connectionId) {
        HashMap<String, String> stringStringHashMap = this.connectionIdContext.get(connectionId);
        return stringStringHashMap == null ? null : new HashMap<String, String>(stringStringHashMap);
    }

    public String getListenKeyMd5(String connectionId, String groupKey) {
        Map groupKeyContexts = this.connectionIdContext.get(connectionId);
        return groupKeyContexts == null ? null : (String)groupKeyContexts.get(groupKey);
    }
}

