/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EBSOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EBSOptions> {
    private static final SdkField<Boolean> EBS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EBSEnabled").getter(EBSOptions.getter(EBSOptions::ebsEnabled)).setter(EBSOptions.setter(Builder::ebsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSEnabled").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(EBSOptions.getter(EBSOptions::volumeTypeAsString)).setter(EBSOptions.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(EBSOptions.getter(EBSOptions::volumeSize)).setter(EBSOptions.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(EBSOptions.getter(EBSOptions::iops)).setter(EBSOptions.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(EBSOptions.getter(EBSOptions::throughput)).setter(EBSOptions.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_ENABLED_FIELD, VOLUME_TYPE_FIELD, VOLUME_SIZE_FIELD, IOPS_FIELD, THROUGHPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EBSOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean ebsEnabled;
    private final String volumeType;
    private final Integer volumeSize;
    private final Integer iops;
    private final Integer throughput;

    private EBSOptions(BuilderImpl builder) {
        this.ebsEnabled = builder.ebsEnabled;
        this.volumeType = builder.volumeType;
        this.volumeSize = builder.volumeSize;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
    }

    public final Boolean ebsEnabled() {
        return this.ebsEnabled;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSOptions)) {
            return false;
        }
        EBSOptions other = (EBSOptions)obj;
        return Objects.equals(this.ebsEnabled(), other.ebsEnabled()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput());
    }

    public final String toString() {
        return ToString.builder((String)"EBSOptions").add("EBSEnabled", (Object)this.ebsEnabled()).add("VolumeType", (Object)this.volumeTypeAsString()).add("VolumeSize", (Object)this.volumeSize()).add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EBSEnabled": {
                return Optional.ofNullable(clazz.cast(this.ebsEnabled()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EBSEnabled", EBS_ENABLED_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSOptions, T> g) {
        return obj -> g.apply((EBSOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ebsEnabled;
        private String volumeType;
        private Integer volumeSize;
        private Integer iops;
        private Integer throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSOptions model) {
            this.ebsEnabled(model.ebsEnabled);
            this.volumeType(model.volumeType);
            this.volumeSize(model.volumeSize);
            this.iops(model.iops);
            this.throughput(model.throughput);
        }

        public final Boolean getEbsEnabled() {
            return this.ebsEnabled;
        }

        public final void setEbsEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
        }

        @Override
        public final Builder ebsEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public EBSOptions build() {
            return new EBSOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EBSOptions> {
        public Builder ebsEnabled(Boolean var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder volumeSize(Integer var1);

        public Builder iops(Integer var1);

        public Builder throughput(Integer var1);
    }
}

