/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;

public class GetSavingsPlansCoveragePublisher
implements SdkPublisher<GetSavingsPlansCoverageResponse> {
    private final CostExplorerAsyncClient client;
    private final GetSavingsPlansCoverageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSavingsPlansCoveragePublisher(CostExplorerAsyncClient client, GetSavingsPlansCoverageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSavingsPlansCoveragePublisher(CostExplorerAsyncClient client, GetSavingsPlansCoverageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSavingsPlansCoverageResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSavingsPlansCoverageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetSavingsPlansCoverageResponseFetcher
    implements AsyncPageFetcher<GetSavingsPlansCoverageResponse> {
        private GetSavingsPlansCoverageResponseFetcher() {
        }

        public boolean hasNextPage(GetSavingsPlansCoverageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSavingsPlansCoverageResponse> nextPage(GetSavingsPlansCoverageResponse previousPage) {
            if (previousPage == null) {
                return GetSavingsPlansCoveragePublisher.this.client.getSavingsPlansCoverage(GetSavingsPlansCoveragePublisher.this.firstRequest);
            }
            return GetSavingsPlansCoveragePublisher.this.client.getSavingsPlansCoverage((GetSavingsPlansCoverageRequest)((Object)GetSavingsPlansCoveragePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

