/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansCoverageData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansCoverageData> {
    private static final SdkField<String> SPEND_COVERED_BY_SAVINGS_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SavingsPlansCoverageData.getter(SavingsPlansCoverageData::spendCoveredBySavingsPlans)).setter(SavingsPlansCoverageData.setter(Builder::spendCoveredBySavingsPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpendCoveredBySavingsPlans").build()}).build();
    private static final SdkField<String> ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SavingsPlansCoverageData.getter(SavingsPlansCoverageData::onDemandCost)).setter(SavingsPlansCoverageData.setter(Builder::onDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandCost").build()}).build();
    private static final SdkField<String> TOTAL_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SavingsPlansCoverageData.getter(SavingsPlansCoverageData::totalCost)).setter(SavingsPlansCoverageData.setter(Builder::totalCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCost").build()}).build();
    private static final SdkField<String> COVERAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SavingsPlansCoverageData.getter(SavingsPlansCoverageData::coveragePercentage)).setter(SavingsPlansCoverageData.setter(Builder::coveragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoveragePercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEND_COVERED_BY_SAVINGS_PLANS_FIELD, ON_DEMAND_COST_FIELD, TOTAL_COST_FIELD, COVERAGE_PERCENTAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String spendCoveredBySavingsPlans;
    private final String onDemandCost;
    private final String totalCost;
    private final String coveragePercentage;

    private SavingsPlansCoverageData(BuilderImpl builder) {
        this.spendCoveredBySavingsPlans = builder.spendCoveredBySavingsPlans;
        this.onDemandCost = builder.onDemandCost;
        this.totalCost = builder.totalCost;
        this.coveragePercentage = builder.coveragePercentage;
    }

    public String spendCoveredBySavingsPlans() {
        return this.spendCoveredBySavingsPlans;
    }

    public String onDemandCost() {
        return this.onDemandCost;
    }

    public String totalCost() {
        return this.totalCost;
    }

    public String coveragePercentage() {
        return this.coveragePercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spendCoveredBySavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.coveragePercentage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansCoverageData)) {
            return false;
        }
        SavingsPlansCoverageData other = (SavingsPlansCoverageData)obj;
        return Objects.equals(this.spendCoveredBySavingsPlans(), other.spendCoveredBySavingsPlans()) && Objects.equals(this.onDemandCost(), other.onDemandCost()) && Objects.equals(this.totalCost(), other.totalCost()) && Objects.equals(this.coveragePercentage(), other.coveragePercentage());
    }

    public String toString() {
        return ToString.builder((String)"SavingsPlansCoverageData").add("SpendCoveredBySavingsPlans", (Object)this.spendCoveredBySavingsPlans()).add("OnDemandCost", (Object)this.onDemandCost()).add("TotalCost", (Object)this.totalCost()).add("CoveragePercentage", (Object)this.coveragePercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpendCoveredBySavingsPlans": {
                return Optional.ofNullable(clazz.cast(this.spendCoveredBySavingsPlans()));
            }
            case "OnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.onDemandCost()));
            }
            case "TotalCost": {
                return Optional.ofNullable(clazz.cast(this.totalCost()));
            }
            case "CoveragePercentage": {
                return Optional.ofNullable(clazz.cast(this.coveragePercentage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansCoverageData, T> g) {
        return obj -> g.apply((SavingsPlansCoverageData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spendCoveredBySavingsPlans;
        private String onDemandCost;
        private String totalCost;
        private String coveragePercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansCoverageData model) {
            this.spendCoveredBySavingsPlans(model.spendCoveredBySavingsPlans);
            this.onDemandCost(model.onDemandCost);
            this.totalCost(model.totalCost);
            this.coveragePercentage(model.coveragePercentage);
        }

        public final String getSpendCoveredBySavingsPlans() {
            return this.spendCoveredBySavingsPlans;
        }

        @Override
        public final Builder spendCoveredBySavingsPlans(String spendCoveredBySavingsPlans) {
            this.spendCoveredBySavingsPlans = spendCoveredBySavingsPlans;
            return this;
        }

        public final void setSpendCoveredBySavingsPlans(String spendCoveredBySavingsPlans) {
            this.spendCoveredBySavingsPlans = spendCoveredBySavingsPlans;
        }

        public final String getOnDemandCost() {
            return this.onDemandCost;
        }

        @Override
        public final Builder onDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
            return this;
        }

        public final void setOnDemandCost(String onDemandCost) {
            this.onDemandCost = onDemandCost;
        }

        public final String getTotalCost() {
            return this.totalCost;
        }

        @Override
        public final Builder totalCost(String totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final void setTotalCost(String totalCost) {
            this.totalCost = totalCost;
        }

        public final String getCoveragePercentage() {
            return this.coveragePercentage;
        }

        @Override
        public final Builder coveragePercentage(String coveragePercentage) {
            this.coveragePercentage = coveragePercentage;
            return this;
        }

        public final void setCoveragePercentage(String coveragePercentage) {
            this.coveragePercentage = coveragePercentage;
        }

        public SavingsPlansCoverageData build() {
            return new SavingsPlansCoverageData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansCoverageData> {
        public Builder spendCoveredBySavingsPlans(String var1);

        public Builder onDemandCost(String var1);

        public Builder totalCost(String var1);

        public Builder coveragePercentage(String var1);
    }
}

