/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amp.model.AmpResponse;
import software.amazon.awssdk.services.amp.model.ScraperSummary;
import software.amazon.awssdk.services.amp.model.ScraperSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScrapersResponse
extends AmpResponse
implements ToCopyableBuilder<Builder, ListScrapersResponse> {
    private static final SdkField<List<ScraperSummary>> SCRAPERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scrapers").getter(ListScrapersResponse.getter(ListScrapersResponse::scrapers)).setter(ListScrapersResponse.setter(Builder::scrapers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScraperSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScrapersResponse.getter(ListScrapersResponse::nextToken)).setter(ListScrapersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAPERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScraperSummary> scrapers;
    private final String nextToken;

    private ListScrapersResponse(BuilderImpl builder) {
        super(builder);
        this.scrapers = builder.scrapers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScrapers() {
        return this.scrapers != null && !(this.scrapers instanceof SdkAutoConstructList);
    }

    public final List<ScraperSummary> scrapers() {
        return this.scrapers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScrapers() ? this.scrapers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScrapersResponse)) {
            return false;
        }
        ListScrapersResponse other = (ListScrapersResponse)((Object)obj);
        return this.hasScrapers() == other.hasScrapers() && Objects.equals(this.scrapers(), other.scrapers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScrapersResponse").add("Scrapers", this.hasScrapers() ? this.scrapers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scrapers": {
                return Optional.ofNullable(clazz.cast(this.scrapers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScrapersResponse, T> g) {
        return obj -> g.apply((ListScrapersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpResponse.BuilderImpl
    implements Builder {
        private List<ScraperSummary> scrapers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScrapersResponse model) {
            super(model);
            this.scrapers(model.scrapers);
            this.nextToken(model.nextToken);
        }

        public final List<ScraperSummary.Builder> getScrapers() {
            List<ScraperSummary.Builder> result = ScraperSummaryListCopier.copyToBuilder(this.scrapers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScrapers(Collection<ScraperSummary.BuilderImpl> scrapers) {
            this.scrapers = ScraperSummaryListCopier.copyFromBuilder(scrapers);
        }

        @Override
        public final Builder scrapers(Collection<ScraperSummary> scrapers) {
            this.scrapers = ScraperSummaryListCopier.copy(scrapers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scrapers(ScraperSummary ... scrapers) {
            this.scrapers(Arrays.asList(scrapers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scrapers(Consumer<ScraperSummary.Builder> ... scrapers) {
            this.scrapers(Stream.of(scrapers).map(c -> (ScraperSummary)((ScraperSummary.Builder)ScraperSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScrapersResponse build() {
            return new ListScrapersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmpResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScrapersResponse> {
        public Builder scrapers(Collection<ScraperSummary> var1);

        public Builder scrapers(ScraperSummary ... var1);

        public Builder scrapers(Consumer<ScraperSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

