/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.types;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class Expirations<K> {
    private final TimeUnit unit;
    private final Map<K, TimeToLive> expirations;

    Expirations(TimeUnit unit, Map<K, TimeToLive> expirations) {
        this.unit = unit;
        this.expirations = expirations;
    }

    public static <K> Expirations<K> of(TimeUnit targetUnit, List<K> keys, Timeouts timeouts) {
        if (keys.size() != timeouts.size()) {
            throw new IllegalArgumentException("Keys and Timeouts must be of same size but was %s vs %s".formatted(keys.size(), timeouts.size()));
        }
        if (keys.size() == 1) {
            return new Expirations<K>(targetUnit, Map.of(keys.iterator().next(), TimeToLive.of(timeouts.raw().iterator().next(), timeouts.timeUnit())));
        }
        LinkedHashMap target = CollectionUtils.newLinkedHashMap((int)keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            target.put(keys.get(i), TimeToLive.of(timeouts.get(i), timeouts.timeUnit()));
        }
        return new Expirations<K>(targetUnit, target);
    }

    public Set<K> persistent() {
        return this.filterByState(TimeToLive.PERSISTENT);
    }

    public Set<K> missing() {
        return this.filterByState(TimeToLive.MISSING);
    }

    public List<TimeToLive> ttl() {
        return this.expirations.values().stream().map(it -> it.convert(this.unit)).toList();
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public List<Map.Entry<K, Duration>> expiring() {
        return this.expirations.entrySet().stream().filter(it -> !((TimeToLive)it.getValue()).isMissing() && !((TimeToLive)it.getValue()).isPersistent()).map(it -> Map.entry(it.getKey(), Expirations.toDuration((TimeToLive)it.getValue()))).toList();
    }

    public Collection<K> keys() {
        return this.expirations.keySet();
    }

    @Nullable
    public TimeToLive expirationOf(K key) {
        TimeToLive timeToLive = this.expirations.get(key);
        if (timeToLive == null) {
            return null;
        }
        return timeToLive.convert(this.unit);
    }

    @Nullable
    public Duration ttlOf(K key) {
        return Expirations.toDuration(this.expirationOf(key));
    }

    private Set<K> filterByState(TimeToLive filter) {
        return this.expirations.entrySet().stream().filter(entry -> ((TimeToLive)entry.getValue()).equals(filter)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Nullable
    static Duration toDuration(@Nullable TimeToLive timeToLive) {
        if (timeToLive == null || timeToLive.sourceUnit == null) {
            return null;
        }
        return Duration.of(timeToLive.raw(), timeToLive.sourceUnit.toChronoUnit());
    }

    public record Timeouts(TimeUnit timeUnit, List<Long> raw) {
        Long get(int index) {
            return this.raw.get(index);
        }

        public int size() {
            return this.raw.size();
        }
    }

    public static class TimeToLive {
        public static TimeToLive MISSING = new TimeToLive(-2L);
        public static TimeToLive PERSISTENT = new TimeToLive(-1L);
        @Nullable
        private final TimeUnit sourceUnit;
        @Nullable
        private final TimeUnit targetUnit;
        private final long raw;

        TimeToLive(long value) {
            this(value, null);
        }

        TimeToLive(long value, @Nullable TimeUnit sourceUnit) {
            this(value, sourceUnit, null);
        }

        TimeToLive(long value, @Nullable TimeUnit sourceUnit, @Nullable TimeUnit targetUnit) {
            this.raw = value;
            this.sourceUnit = sourceUnit;
            this.targetUnit = targetUnit;
        }

        public static TimeToLive of(Number value, TimeUnit timeUnit) {
            return switch (value.intValue()) {
                case -2 -> MISSING;
                case -1 -> PERSISTENT;
                default -> new TimeToLive(value.longValue(), timeUnit);
            };
        }

        public long raw() {
            return this.raw;
        }

        public long value() {
            if (this.sourceUnit == null || this.targetUnit == null) {
                return this.raw;
            }
            return this.targetUnit.convert(this.raw, this.sourceUnit);
        }

        public TimeToLive convert(TimeUnit timeUnit) {
            if (this.sourceUnit == null || ObjectUtils.nullSafeEquals((Object)((Object)this.sourceUnit), (Object)((Object)timeUnit))) {
                return this;
            }
            return new TimeToLive(this.raw, this.sourceUnit, timeUnit);
        }

        public boolean isPersistent() {
            return PERSISTENT.raw() == this.raw();
        }

        public boolean isMissing() {
            return MISSING.raw() == this.raw();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeToLive)) {
                return false;
            }
            TimeToLive that = (TimeToLive)o;
            if (!ObjectUtils.nullSafeEquals((Object)((Object)this.sourceUnit), (Object)((Object)that.sourceUnit))) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)((Object)this.targetUnit), (Object)((Object)that.targetUnit))) {
                return false;
            }
            return this.raw == that.raw;
        }

        public int hashCode() {
            return Objects.hash(this.raw);
        }

        public String toString() {
            return switch ((int)this.raw()) {
                case -2 -> "MISSING";
                case -1 -> "PERSISTENT";
                default -> "%d %s".formatted(new Object[]{this.raw(), this.sourceUnit});
            };
        }
    }
}

