/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.support;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.support.EnvironmentPostProcessorsFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;

class SpringFactoriesEnvironmentPostProcessorsFactory
implements EnvironmentPostProcessorsFactory {
    private final SpringFactoriesLoader loader;

    SpringFactoriesEnvironmentPostProcessorsFactory(SpringFactoriesLoader loader) {
        this.loader = loader;
    }

    @Override
    public List<EnvironmentPostProcessor> getEnvironmentPostProcessors(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext) {
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(DeferredLogFactory.class, (Object)logFactory);
        argumentResolver = argumentResolver.and(ConfigurableBootstrapContext.class, (Object)bootstrapContext);
        argumentResolver = argumentResolver.and(BootstrapContext.class, (Object)bootstrapContext);
        argumentResolver = argumentResolver.and(BootstrapRegistry.class, (Object)bootstrapContext);
        ArrayList<org.springframework.boot.env.EnvironmentPostProcessor> postProcessors = new ArrayList<org.springframework.boot.env.EnvironmentPostProcessor>();
        postProcessors.addAll(this.loader.load(EnvironmentPostProcessor.class, argumentResolver));
        postProcessors.addAll(this.loadDeprecatedPostProcessors(argumentResolver));
        AnnotationAwareOrderComparator.sort(postProcessors);
        return postProcessors.stream().map(Adapter::apply).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<org.springframework.boot.env.EnvironmentPostProcessor> loadDeprecatedPostProcessors(SpringFactoriesLoader.ArgumentResolver argumentResolver) {
        return this.loader.load(org.springframework.boot.env.EnvironmentPostProcessor.class, argumentResolver);
    }

    record Adapter(org.springframework.boot.env.EnvironmentPostProcessor postProcessor) implements EnvironmentPostProcessor
    {
        @Override
        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            this.postProcessor.postProcessEnvironment(environment, application);
        }

        static EnvironmentPostProcessor apply(Object source) {
            if (source instanceof EnvironmentPostProcessor) {
                EnvironmentPostProcessor environmentPostProcessor = (EnvironmentPostProcessor)source;
                return environmentPostProcessor;
            }
            return new Adapter((org.springframework.boot.env.EnvironmentPostProcessor)source);
        }
    }
}

