/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.classloader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.util.Assert;

public class ClassLoaderFileURLStreamHandler
extends URLStreamHandler {
    private final ClassLoaderFile file;

    public ClassLoaderFileURLStreamHandler(ClassLoaderFile file) {
        this.file = file;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    private class Connection
    extends URLConnection {
        Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            byte[] contents = ClassLoaderFileURLStreamHandler.this.file.getContents();
            Assert.state((contents != null ? 1 : 0) != 0, (String)"'contents' must not be null");
            return new ByteArrayInputStream(contents);
        }

        @Override
        public long getLastModified() {
            return ClassLoaderFileURLStreamHandler.this.file.getLastModified();
        }
    }
}

