/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch._types.query_dsl.Like;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MoreLikeThisQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boostTerms;
    @Nullable
    private final Boolean failOnUnsupportedField;
    private final List<String> fields;
    @Nullable
    private final Boolean include;
    private final List<Like> like;
    @Nullable
    private final Integer maxDocFreq;
    @Nullable
    private final Integer maxQueryTerms;
    @Nullable
    private final Integer maxWordLength;
    @Nullable
    private final Integer minDocFreq;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Integer minTermFreq;
    @Nullable
    private final Integer minWordLength;
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final String routing;
    private final List<String> stopWords;
    private final List<Like> unlike;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MoreLikeThisQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MoreLikeThisQuery::setupMoreLikeThisQueryDeserializer);

    private MoreLikeThisQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boostTerms = builder.boostTerms;
        this.failOnUnsupportedField = builder.failOnUnsupportedField;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.include = builder.include;
        this.like = ApiTypeHelper.unmodifiableRequired(builder.like, (Object)this, "like");
        this.maxDocFreq = builder.maxDocFreq;
        this.maxQueryTerms = builder.maxQueryTerms;
        this.maxWordLength = builder.maxWordLength;
        this.minDocFreq = builder.minDocFreq;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.minTermFreq = builder.minTermFreq;
        this.minWordLength = builder.minWordLength;
        this.perFieldAnalyzer = ApiTypeHelper.unmodifiable(builder.perFieldAnalyzer);
        this.routing = builder.routing;
        this.stopWords = ApiTypeHelper.unmodifiable(builder.stopWords);
        this.unlike = ApiTypeHelper.unmodifiable(builder.unlike);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MoreLikeThisQuery of(Function<Builder, ObjectBuilder<MoreLikeThisQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.MoreLikeThis;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Double boostTerms() {
        return this.boostTerms;
    }

    @Nullable
    public final Boolean failOnUnsupportedField() {
        return this.failOnUnsupportedField;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean include() {
        return this.include;
    }

    public final List<Like> like() {
        return this.like;
    }

    @Nullable
    public final Integer maxDocFreq() {
        return this.maxDocFreq;
    }

    @Nullable
    public final Integer maxQueryTerms() {
        return this.maxQueryTerms;
    }

    @Nullable
    public final Integer maxWordLength() {
        return this.maxWordLength;
    }

    @Nullable
    public final Integer minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final Integer minTermFreq() {
        return this.minTermFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    public final Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final List<String> stopWords() {
        return this.stopWords;
    }

    public final List<Like> unlike() {
        return this.unlike;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boostTerms != null) {
            generator.writeKey("boost_terms");
            generator.write(this.boostTerms.doubleValue());
        }
        if (this.failOnUnsupportedField != null) {
            generator.writeKey("fail_on_unsupported_field");
            generator.write(this.failOnUnsupportedField.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.write(this.include.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.like)) {
            generator.writeKey("like");
            generator.writeStartArray();
            for (Like like : this.like) {
                like.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxDocFreq != null) {
            generator.writeKey("max_doc_freq");
            generator.write(this.maxDocFreq.intValue());
        }
        if (this.maxQueryTerms != null) {
            generator.writeKey("max_query_terms");
            generator.write(this.maxQueryTerms.intValue());
        }
        if (this.maxWordLength != null) {
            generator.writeKey("max_word_length");
            generator.write(this.maxWordLength.intValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.minTermFreq != null) {
            generator.writeKey("min_term_freq");
            generator.write(this.minTermFreq.intValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (ApiTypeHelper.isDefined(this.perFieldAnalyzer)) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry entry : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (ApiTypeHelper.isDefined(this.stopWords)) {
            generator.writeKey("stop_words");
            generator.writeStartArray();
            for (String string : this.stopWords) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.unlike)) {
            generator.writeKey("unlike");
            generator.writeStartArray();
            for (Like like : this.unlike) {
                like.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return new Builder().analyzer(this.analyzer).boostTerms(this.boostTerms).failOnUnsupportedField(this.failOnUnsupportedField).fields(this.fields).include(this.include).like(this.like).maxDocFreq(this.maxDocFreq).maxQueryTerms(this.maxQueryTerms).maxWordLength(this.maxWordLength).minDocFreq(this.minDocFreq).minimumShouldMatch(this.minimumShouldMatch).minTermFreq(this.minTermFreq).minWordLength(this.minWordLength).perFieldAnalyzer(this.perFieldAnalyzer).routing(this.routing).stopWords(this.stopWords).unlike(this.unlike).version(this.version).versionType(this.versionType);
    }

    protected static void setupMoreLikeThisQueryDeserializer(ObjectDeserializer<Builder> op) {
        MoreLikeThisQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::boostTerms, JsonpDeserializer.doubleDeserializer(), "boost_terms");
        op.add(Builder::failOnUnsupportedField, JsonpDeserializer.booleanDeserializer(), "fail_on_unsupported_field");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::include, JsonpDeserializer.booleanDeserializer(), "include");
        op.add(Builder::like, JsonpDeserializer.arrayDeserializer(Like._DESERIALIZER), "like");
        op.add(Builder::maxDocFreq, JsonpDeserializer.integerDeserializer(), "max_doc_freq");
        op.add(Builder::maxQueryTerms, JsonpDeserializer.integerDeserializer(), "max_query_terms");
        op.add(Builder::maxWordLength, JsonpDeserializer.integerDeserializer(), "max_word_length");
        op.add(Builder::minDocFreq, JsonpDeserializer.integerDeserializer(), "min_doc_freq");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::minTermFreq, JsonpDeserializer.integerDeserializer(), "min_term_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::stopWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stop_words");
        op.add(Builder::unlike, JsonpDeserializer.arrayDeserializer(Like._DESERIALIZER), "unlike");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MoreLikeThisQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boostTerms;
        @Nullable
        private Boolean failOnUnsupportedField;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean include;
        private List<Like> like;
        @Nullable
        private Integer maxDocFreq;
        @Nullable
        private Integer maxQueryTerms;
        @Nullable
        private Integer maxWordLength;
        @Nullable
        private Integer minDocFreq;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Integer minTermFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private String routing;
        @Nullable
        private List<String> stopWords;
        @Nullable
        private List<Like> unlike;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder boostTerms(@Nullable Double value) {
            this.boostTerms = value;
            return this;
        }

        public final Builder failOnUnsupportedField(@Nullable Boolean value) {
            this.failOnUnsupportedField = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder include(@Nullable Boolean value) {
            this.include = value;
            return this;
        }

        public final Builder like(List<Like> list) {
            this.like = Builder._listAddAll(this.like, list);
            return this;
        }

        public final Builder like(Like value, Like ... values) {
            this.like = Builder._listAdd(this.like, value, values);
            return this;
        }

        public final Builder like(Function<Like.Builder, ObjectBuilder<Like>> fn) {
            return this.like(fn.apply(new Like.Builder()).build(), new Like[0]);
        }

        public final Builder maxDocFreq(@Nullable Integer value) {
            this.maxDocFreq = value;
            return this;
        }

        public final Builder maxQueryTerms(@Nullable Integer value) {
            this.maxQueryTerms = value;
            return this;
        }

        public final Builder maxWordLength(@Nullable Integer value) {
            this.maxWordLength = value;
            return this;
        }

        public final Builder minDocFreq(@Nullable Integer value) {
            this.minDocFreq = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder minTermFreq(@Nullable Integer value) {
            this.minTermFreq = value;
            return this;
        }

        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public final Builder perFieldAnalyzer(Map<String, String> map) {
            this.perFieldAnalyzer = Builder._mapPutAll(this.perFieldAnalyzer, map);
            return this;
        }

        public final Builder perFieldAnalyzer(String key, String value) {
            this.perFieldAnalyzer = Builder._mapPut(this.perFieldAnalyzer, key, value);
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder stopWords(List<String> list) {
            this.stopWords = Builder._listAddAll(this.stopWords, list);
            return this;
        }

        public final Builder stopWords(String value, String ... values) {
            this.stopWords = Builder._listAdd(this.stopWords, value, values);
            return this;
        }

        public final Builder unlike(List<Like> list) {
            this.unlike = Builder._listAddAll(this.unlike, list);
            return this;
        }

        public final Builder unlike(Like value, Like ... values) {
            this.unlike = Builder._listAdd(this.unlike, value, values);
            return this;
        }

        public final Builder unlike(Function<Like.Builder, ObjectBuilder<Like>> fn) {
            return this.unlike(fn.apply(new Like.Builder()).build(), new Like[0]);
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MoreLikeThisQuery build() {
            this._checkSingleUse();
            return new MoreLikeThisQuery(this);
        }
    }
}

