/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Clauses;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.parser.ExpressionCreatedEventType;
import org.neo4j.cypherdsl.parser.InvocationCreatedEventType;
import org.neo4j.cypherdsl.parser.LabelParsedEventType;
import org.neo4j.cypherdsl.parser.MatchDefinition;
import org.neo4j.cypherdsl.parser.PatternElementCreatedEventType;
import org.neo4j.cypherdsl.parser.ReturnDefinition;
import org.neo4j.cypherdsl.parser.TypeParsedEventType;

@API(status=API.Status.STABLE, since="2021.3.0")
public final class Options {
    private static final Options DEFAULT_OPTIONS = Options.newOptions().build();
    private final BiFunction<LabelParsedEventType, Collection<String>, Collection<String>> labelFilter;
    private final BiFunction<TypeParsedEventType, Collection<String>, Collection<String>> typeFilter;
    private final Map<ExpressionCreatedEventType, List<Function<Expression, ? extends Expression>>> onNewExpressionCallbacks;
    private final Map<PatternElementCreatedEventType, List<UnaryOperator<PatternElement>>> onNewPatternElementCallbacks;
    private final Map<InvocationCreatedEventType, List<UnaryOperator<Visitable>>> onNewInvocationCallbacks;
    private final Function<ReturnDefinition, Return> returnClauseFactory;
    private final Function<MatchDefinition, Match> matchClauseFactory;
    private final boolean createSortedMaps;
    private boolean alwaysCreateRelationshipsLTR;
    private final Map<String, Object> parameterValues;

    public static Options defaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public static Builder newOptions() {
        return Builder.newConfig();
    }

    private Options(Builder builder) {
        this.labelFilter = builder.labelFilter;
        this.typeFilter = builder.typeFilter;
        EnumMap tmp = new EnumMap(ExpressionCreatedEventType.class);
        builder.onNewExpressionCallbacks.forEach((k, v) -> tmp.put((ExpressionCreatedEventType)((Object)k), List.copyOf(v)));
        this.onNewExpressionCallbacks = Map.copyOf(tmp);
        EnumMap tmp2 = new EnumMap(PatternElementCreatedEventType.class);
        builder.onNewPatternElementCallbacks.forEach((k, v) -> tmp2.put((PatternElementCreatedEventType)((Object)k), List.copyOf(v)));
        this.onNewPatternElementCallbacks = Map.copyOf(tmp2);
        EnumMap tmp3 = new EnumMap(InvocationCreatedEventType.class);
        builder.onNewInvocationCallbacks.forEach((k, v) -> tmp3.put((InvocationCreatedEventType)((Object)k), List.copyOf(v)));
        this.onNewInvocationCallbacks = Map.copyOf(tmp3);
        this.returnClauseFactory = builder.returnClauseFactory != null ? builder.returnClauseFactory : returnDefinition -> Clauses.returning((boolean)returnDefinition.isDistinct(), returnDefinition.getExpressions(), returnDefinition.getOptionalSortItems(), (Expression)returnDefinition.getOptionalSkip(), (Expression)returnDefinition.getOptionalLimit());
        this.matchClauseFactory = builder.matchClauseFactory != null ? builder.matchClauseFactory : returnDefinition -> (Match)Clauses.match((boolean)returnDefinition.optional(), returnDefinition.patternElements(), (Where)returnDefinition.optionalWhere(), returnDefinition.optionalHints());
        this.createSortedMaps = builder.createSortedMaps;
        this.alwaysCreateRelationshipsLTR = builder.alwaysCreateRelationshipsLTR;
        this.parameterValues = builder.parameterValues;
    }

    BiFunction<LabelParsedEventType, Collection<String>, Collection<String>> getLabelFilter() {
        return this.labelFilter;
    }

    BiFunction<TypeParsedEventType, Collection<String>, Collection<String>> getTypeFilter() {
        return this.typeFilter;
    }

    Map<ExpressionCreatedEventType, List<Function<Expression, ? extends Expression>>> getOnNewExpressionCallbacks() {
        return this.onNewExpressionCallbacks;
    }

    Map<PatternElementCreatedEventType, List<UnaryOperator<PatternElement>>> getOnNewPatternElementCallbacks() {
        return this.onNewPatternElementCallbacks;
    }

    Function<ReturnDefinition, Return> getReturnClauseFactory() {
        return this.returnClauseFactory;
    }

    Function<MatchDefinition, Match> getMatchClauseFactory() {
        return this.matchClauseFactory;
    }

    boolean isCreateSortedMaps() {
        return this.createSortedMaps;
    }

    boolean isAlwaysCreateRelationshipsLTR() {
        return this.alwaysCreateRelationshipsLTR;
    }

    Map<InvocationCreatedEventType, List<UnaryOperator<Visitable>>> getOnNewInvocationCallbacks() {
        return this.onNewInvocationCallbacks;
    }

    boolean areDefault() {
        return this == DEFAULT_OPTIONS;
    }

    Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public static final class Builder {
        private BiFunction<LabelParsedEventType, Collection<String>, Collection<String>> labelFilter = (e, l) -> l;
        private BiFunction<TypeParsedEventType, Collection<String>, Collection<String>> typeFilter = (e, t) -> t;
        private final Map<ExpressionCreatedEventType, List<Function<Expression, ? extends Expression>>> onNewExpressionCallbacks = new EnumMap<ExpressionCreatedEventType, List<Function<Expression, ? extends Expression>>>(ExpressionCreatedEventType.class);
        private final Map<PatternElementCreatedEventType, List<UnaryOperator<PatternElement>>> onNewPatternElementCallbacks = new EnumMap<PatternElementCreatedEventType, List<UnaryOperator<PatternElement>>>(PatternElementCreatedEventType.class);
        private final Map<InvocationCreatedEventType, List<UnaryOperator<Visitable>>> onNewInvocationCallbacks = new EnumMap<InvocationCreatedEventType, List<UnaryOperator<Visitable>>>(InvocationCreatedEventType.class);
        private Function<ReturnDefinition, Return> returnClauseFactory;
        private Function<MatchDefinition, Match> matchClauseFactory;
        private Map<String, Object> parameterValues = Map.of();
        private boolean createSortedMaps = false;
        private boolean alwaysCreateRelationshipsLTR = false;

        private Builder() {
        }

        static Builder newConfig() {
            return new Builder();
        }

        public Builder withLabelFilter(BiFunction<LabelParsedEventType, Collection<String>, Collection<String>> labelFilter) {
            if (labelFilter == null) {
                throw new IllegalArgumentException("Label filter may not be null.");
            }
            this.labelFilter = labelFilter;
            return this;
        }

        public Builder withTypeFilter(BiFunction<TypeParsedEventType, Collection<String>, Collection<String>> typeFilter) {
            if (typeFilter == null) {
                throw new IllegalArgumentException("Type filter may not be null.");
            }
            this.typeFilter = typeFilter;
            return this;
        }

        public <T extends Expression> Builder withCallback(ExpressionCreatedEventType expressionCreatedEventType, Class<T> resultingType, Function<Expression, T> callback) {
            if (!expressionCreatedEventType.getTypeProduced().isAssignableFrom(resultingType)) {
                throw new IllegalArgumentException("The type that is produced by '" + String.valueOf((Object)expressionCreatedEventType) + "' is not compatible with " + String.valueOf(resultingType));
            }
            List callbacks = this.onNewExpressionCallbacks.computeIfAbsent(expressionCreatedEventType, k -> new ArrayList());
            callbacks.add(callback);
            return this;
        }

        public Builder withCallback(PatternElementCreatedEventType patternElementCreatedEventType, UnaryOperator<PatternElement> callback) {
            List callbacks = this.onNewPatternElementCallbacks.computeIfAbsent(patternElementCreatedEventType, k -> new ArrayList());
            callbacks.add(callback);
            return this;
        }

        public <T extends Visitable> Builder withCallback(InvocationCreatedEventType invocationCreatedEventType, Class<T> resultingType, UnaryOperator<T> callback) {
            if (!invocationCreatedEventType.getTypeProduced().isAssignableFrom(resultingType)) {
                throw new IllegalArgumentException("The type that is produced by '" + String.valueOf((Object)invocationCreatedEventType) + "' is not compatible with " + String.valueOf(resultingType));
            }
            List callbacks = this.onNewInvocationCallbacks.computeIfAbsent(invocationCreatedEventType, k -> new ArrayList());
            callbacks.add(callback);
            return this;
        }

        public Builder withReturnClauseFactory(Function<ReturnDefinition, Return> returnClauseFactory) {
            this.returnClauseFactory = returnClauseFactory;
            return this;
        }

        public Builder withMatchClauseFactory(Function<MatchDefinition, Match> matchClauseFactory) {
            this.matchClauseFactory = matchClauseFactory;
            return this;
        }

        public Builder createSortedMaps(boolean createSortedMaps) {
            this.createSortedMaps = createSortedMaps;
            return this;
        }

        public Builder alwaysCreateRelationshipsLTR(boolean alwaysCreateRelationshipsLTR) {
            this.alwaysCreateRelationshipsLTR = alwaysCreateRelationshipsLTR;
            return this;
        }

        public Builder withParameterValues(Map<String, Object> newParameterValues) {
            this.parameterValues = newParameterValues == null ? Map.of() : Collections.unmodifiableMap(new HashMap<String, Object>(newParameterValues));
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

