/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AsciiAuthThread;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.BinaryAuthThread;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.compat.SpyThread;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;

public class AuthThreadMonitor
extends SpyObject {
    private final Map<Object, Thread> nodeMap = new HashMap<Object, Thread>();

    public synchronized void authConnection(MemcachedConnection conn, OperationFactory opFact, AuthDescriptor authDescriptor, MemcachedNode node) {
        this.interruptOldAuth(node);
        SpyThread authenticator = opFact instanceof BinaryOperationFactory ? new BinaryAuthThread(conn, opFact, authDescriptor, node) : new AsciiAuthThread(conn, opFact, authDescriptor, node);
        this.nodeMap.put(node, authenticator);
    }

    public synchronized void interruptAllPendingAuth() {
        for (Thread toStop : this.nodeMap.values()) {
            if (!toStop.isAlive()) continue;
            this.getLogger().warn("Connection shutdown in progress - interrupting waiting authentication thread.");
            toStop.interrupt();
        }
    }

    private void interruptOldAuth(MemcachedNode nodeToStop) {
        Thread toStop = this.nodeMap.get(nodeToStop);
        if (toStop != null) {
            if (toStop.isAlive()) {
                this.getLogger().warn("Incomplete authentication interrupted for node " + nodeToStop);
                toStop.interrupt();
            }
            this.nodeMap.remove(nodeToStop);
        }
    }

    protected Map<Object, Thread> getNodeMap() {
        return this.nodeMap;
    }
}

