/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespConstants;
import org.infinispan.server.resp.response.LCSResponse;
import org.infinispan.server.resp.response.SetResponse;

public final class Consumers {
    public static final BiConsumer<Object, ByteBufPool> OK_BICONSUMER = (ignore, alloc) -> alloc.acquire(RespConstants.OK.length).writeBytes(RespConstants.OK);
    public static final BiConsumer<Object, ByteBufPool> QUEUED_BICONSUMER = (ignore, alloc) -> alloc.acquire(RespConstants.QUEUED_REPLY.length).writeBytes(RespConstants.QUEUED_REPLY);
    public static final BiConsumer<Long, ByteBufPool> LONG_BICONSUMER = Resp3Handler::handleLongResult;
    public static final BiConsumer<Integer, ByteBufPool> INT_BICONSUMER = (v, bp) -> LONG_BICONSUMER.accept((long)v, (ByteBufPool)bp);
    public static final BiConsumer<Collection<Long>, ByteBufPool> COLLECTION_LONG_BICONSUMER = Resp3Handler::handleCollectionLongResult;
    public static final BiConsumer<Collection<Double>, ByteBufPool> COLLECTION_DOUBLE_BICONSUMER = Resp3Handler::handleCollectionDoubleResult;
    public static final BiConsumer<Double, ByteBufPool> DOUBLE_BICONSUMER = Resp3Handler::handleDoubleResult;
    public static final BiConsumer<byte[], ByteBufPool> BULK_BICONSUMER = Resp3Handler::handleBulkResult;
    public static final BiConsumer<Collection<byte[]>, ByteBufPool> COLLECTION_BULK_BICONSUMER = Resp3Handler::handleCollectionBulkResult;
    public static final BiConsumer<byte[], ByteBufPool> GET_BICONSUMER = (innerValueBytes, alloc) -> {
        if (innerValueBytes != null) {
            ByteBufferUtils.bytesToResult(innerValueBytes, alloc);
        } else {
            ByteBufferUtils.stringToByteBufAscii("$-1\r\n", alloc);
        }
    };
    public static final BiConsumer<Collection<byte[]>, ByteBufPool> GET_ARRAY_BICONSUMER = (innerValueBytes, alloc) -> {
        if (innerValueBytes != null) {
            ByteBufferUtils.bytesToResult(innerValueBytes, alloc);
        } else {
            ByteBufferUtils.stringToByteBufAscii("$-1\r\n", alloc);
        }
    };
    public static final BiConsumer<Object, ByteBufPool> LONG_ELSE_COLLECTION = (res, alloc) -> {
        if (res instanceof Long) {
            LONG_BICONSUMER.accept((Long)res, (ByteBufPool)alloc);
        } else {
            GET_ARRAY_BICONSUMER.accept((Collection)res, (ByteBufPool)alloc);
        }
    };
    public static final BiConsumer<Collection<ScoredValue<byte[]>>, ByteBufPool> GET_OBJ_WRAPPER_ARRAY_BICONSUMER = (innerValueBytes, alloc) -> {
        if (innerValueBytes != null) {
            ByteBufferUtils.bytesToResultWrapped(innerValueBytes, alloc);
        } else {
            ByteBufferUtils.stringToByteBufAscii("$-1\r\n", alloc);
        }
    };
    public static final BiConsumer<byte[], ByteBufPool> DELETE_BICONSUMER = (prev, alloc) -> ByteBufferUtils.stringToByteBufAscii(":" + (prev == null ? "0" : "1") + "\r\n", alloc);
    public static final BiConsumer<SetResponse, ByteBufPool> SET_BICONSUMER = (res, alloc) -> {
        if (res.isReturnValue()) {
            GET_BICONSUMER.accept(res.value(), (ByteBufPool)alloc);
            return;
        }
        if (res.isSuccess()) {
            OK_BICONSUMER.accept(res, (ByteBufPool)alloc);
            return;
        }
        GET_BICONSUMER.accept((byte[])null, (ByteBufPool)alloc);
    };
    public static final BiConsumer<LCSResponse, ByteBufPool> LCS_BICONSUMER = (res, alloc) -> {
        if (res.lcs != null) {
            Resp3Handler.handleBulkResult(res.lcs, alloc);
            return;
        }
        if (res.idx == null) {
            Resp3Handler.handleLongResult(Long.valueOf(res.len), alloc);
            return;
        }
        Consumers.handleIdxArray(res, alloc);
    };
    public static final BiConsumer<List, ByteBufPool> LMPOP_BICONSUMER = (res, alloc) -> {
        Resp3Handler.writeArrayPrefix(2, alloc);
        Resp3Handler.handleBulkResult((byte[])res.get(0), alloc);
        Collection values = (Collection)res.get(1);
        Resp3Handler.writeArrayPrefix(values.size(), alloc);
        for (byte[] val : values) {
            Resp3Handler.handleBulkResult(val, alloc);
        }
    };
    public static final BiConsumer<List, ByteBufPool> ZMPOP_BICONSUMER = (res, alloc) -> {
        Resp3Handler.writeArrayPrefix(2, alloc);
        Resp3Handler.handleBulkResult((byte[])res.get(0), alloc);
        Collection values = (Collection)res.get(1);
        Resp3Handler.writeArrayPrefix(values.size(), alloc);
        for (ScoredValue val : values) {
            Resp3Handler.writeArrayPrefix(2, alloc);
            Resp3Handler.handleBulkResult((byte[])val.getValue(), alloc);
            Resp3Handler.handleDoubleResult(val.score(), alloc);
        }
    };

    private Consumers() {
    }

    private static void handleIdxArray(LCSResponse res, ByteBufPool alloc) {
        Resp3Handler.writeArrayPrefix(4, alloc);
        Resp3Handler.handleBulkAsciiResult("matches", alloc);
        Resp3Handler.writeArrayPrefix(res.idx.size(), alloc);
        for (long[] match : res.idx) {
            int size = match.length > 4 ? 3 : 2;
            Resp3Handler.writeArrayPrefix(size, alloc);
            Resp3Handler.writeArrayPrefix(2, alloc);
            Resp3Handler.handleLongResult(match[0], alloc);
            Resp3Handler.handleLongResult(match[1], alloc);
            Resp3Handler.writeArrayPrefix(2, alloc);
            Resp3Handler.handleLongResult(match[2], alloc);
            Resp3Handler.handleLongResult(match[3], alloc);
            if (size != 3) continue;
            Resp3Handler.handleLongResult(match[4], alloc);
        }
        Resp3Handler.handleBulkAsciiResult("len", alloc);
        Resp3Handler.handleLongResult(Long.valueOf(res.len), alloc);
    }
}

