/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.function.BiFunction;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.mapping.reference.MessageReferenceProvider;

final class ProtobufFieldIndexingMetadata
implements IndexedFieldProvider.FieldIndexingMetadata {
    private final Descriptor messageDescriptor;

    ProtobufFieldIndexingMetadata(Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.messageDescriptor = messageDescriptor;
    }

    public boolean isSearchable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldSearchable);
    }

    public boolean isAnalyzed(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldAnalyzed);
    }

    public boolean isNormalized(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldNormalized);
    }

    public boolean isProjectable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldProjectable);
    }

    public boolean isAggregable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldAggregable);
    }

    public boolean isSortable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldSortable);
    }

    public boolean isVector(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isVectorField);
    }

    public Object getNullMarker(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (i == propertyPath.length) {
                IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(md, "Indexed");
                return indexingMetadata == null ? null : indexingMetadata.getNullMarker(field.getName());
            }
            if (field.getJavaType() != JavaType.MESSAGE) break;
            md = field.getMessageType();
        }
        return null;
    }

    private boolean getFlag(String[] propertyPath, BiFunction<IndexingMetadata, String, Boolean> metadataFun) {
        Descriptor md = this.messageDescriptor;
        for (String p : propertyPath) {
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) {
                return false;
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(md, "Indexed");
            if (indexingMetadata == null || !indexingMetadata.isIndexed()) {
                return false;
            }
            if (field.getJavaType() == JavaType.MESSAGE && !MessageReferenceProvider.COMMON_MESSAGE_TYPES.contains(field.getTypeName())) {
                FieldMapping embeddedMapping = indexingMetadata.getFieldMapping(p);
                if (embeddedMapping == null || !embeddedMapping.searchable()) {
                    return false;
                }
            } else {
                return metadataFun.apply(indexingMetadata, field.getName());
            }
            md = field.getMessageType();
        }
        return false;
    }
}

