/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class PopFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Collection<ScoredValue<V>>> {
    public static final AdvancedExternalizer<PopFunction> EXTERNALIZER = new Externalizer();
    private final boolean min;
    private final long count;

    public PopFunction(boolean min, long count) {
        this.min = min;
        this.count = count;
    }

    public Collection<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            SortedSetBucket sortedSetBucket = (SortedSetBucket)existing.get();
            Collection poppedValues = sortedSetBucket.pop(this.min, this.count);
            if (sortedSetBucket.size() == 0L) {
                entryView.remove();
            }
            return poppedValues;
        }
        return Collections.emptyList();
    }

    private static class Externalizer
    implements AdvancedExternalizer<PopFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends PopFunction>> getTypeClasses() {
            return Collections.singleton(PopFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_POP_FUNCTION;
        }

        public void writeObject(ObjectOutput output, PopFunction object) throws IOException {
            output.writeBoolean(object.min);
            output.writeLong(object.count);
        }

        public PopFunction readObject(ObjectInput input) throws IOException {
            return new PopFunction(input.readBoolean(), input.readLong());
        }
    }
}

