/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapRemoveFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Integer> {
    public static final Externalizer EXTERNALIZER = new Externalizer();
    private final Collection<HK> keys;

    public HashMapRemoveFunction(Collection<HK> keys) {
        this.keys = keys;
    }

    public Integer apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        int res = 0;
        Optional existing = view.peek();
        if (existing.isPresent()) {
            HashMapBucket bucket = (HashMapBucket)existing.get();
            res = bucket.removeAll(this.keys);
            if (bucket.isEmpty()) {
                view.remove();
            } else {
                view.set((Object)bucket, new MetaParam.Writable[0]);
            }
        }
        return res;
    }

    private static class Externalizer
    implements AdvancedExternalizer<HashMapRemoveFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends HashMapRemoveFunction>> getTypeClasses() {
            return Collections.singleton(HashMapRemoveFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_REMOVE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapRemoveFunction object) throws IOException {
            output.writeObject(object.keys);
        }

        public HashMapRemoveFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Collection keys = (Collection)input.readObject();
            return new HashMapRemoveFunction(keys);
        }
    }
}

