/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.internal.EmptyArrays;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.client.hotrod.impl.operations.AuthOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ActivationHandler;
import org.infinispan.client.hotrod.impl.transport.netty.OperationChannel;
import org.infinispan.client.hotrod.impl.transport.netty.SaslDecoderEncoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class AuthHandler
extends ActivationHandler {
    private static final Log log = LogFactory.getLog(AuthHandler.class);
    private static final String AUTH_INT = "auth-int";
    private static final String AUTH_CONF = "auth-conf";
    public static final String NAME = "auth-handler";
    private final AuthenticationConfiguration authentication;
    private final SaslClient saslClient;

    public AuthHandler(AuthenticationConfiguration authentication, SaslClient saslClient) {
        this.authentication = authentication;
        this.saslClient = saslClient;
    }

    @Override
    protected void activate(ChannelHandlerContext ctx, OperationChannel operationChannel) {
        Channel channel = ctx.channel();
        AuthMechListOperation op = new AuthMechListOperation();
        operationChannel.forceSendOperation(op);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)op.thenCompose(serverMechs -> {
            byte[] response;
            if (!serverMechs.contains(this.authentication.saslMechanism())) {
                throw Log.HOTROD.unsupportedMech(this.authentication.saslMechanism(), (List<String>)serverMechs);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Authenticating using mech: %s", this.authentication.saslMechanism());
            }
            if (this.saslClient.hasInitialResponse()) {
                try {
                    response = this.evaluateChallenge(this.saslClient, EmptyArrays.EMPTY_BYTES, this.authentication.clientSubject());
                }
                catch (SaslException e) {
                    throw new HotRodClientException(e);
                }
            } else {
                response = EmptyArrays.EMPTY_BYTES;
            }
            AuthOperation authOperation = new AuthOperation(this.authentication.saslMechanism(), response);
            operationChannel.forceSendOperation(authOperation);
            return authOperation;
        })).thenCompose((Function)new ChallengeEvaluator(channel, this.saslClient))).thenRun(() -> {
            String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
            if (qop != null && (qop.equalsIgnoreCase(AUTH_INT) || qop.equalsIgnoreCase(AUTH_CONF))) {
                channel.pipeline().addFirst(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new SaslDecoderEncoder(this.saslClient)});
            } else {
                try {
                    this.saslClient.dispose();
                }
                catch (SaslException e) {
                    log.debug("Exception encountered while closing saslClient", e);
                }
            }
            channel.pipeline().remove((ChannelHandler)this);
            operationChannel.markAcceptingRequests();
        })).exceptionally(throwable -> {
            while (throwable instanceof CompletionException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            channel.pipeline().fireExceptionCaught(throwable);
            return null;
        });
    }

    private byte[] evaluateChallenge(SaslClient saslClient, byte[] challenge, Subject clientSubject) throws SaslException {
        if (clientSubject != null) {
            try {
                return Subject.doAs(clientSubject, () -> saslClient.evaluateChallenge(challenge));
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SaslException) {
                    throw (SaslException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return saslClient.evaluateChallenge(challenge);
    }

    private class ChallengeEvaluator
    implements Function<byte[], CompletableFuture<byte[]>> {
        private final Channel channel;
        private final SaslClient saslClient;

        private ChallengeEvaluator(Channel channel, SaslClient saslClient) {
            this.channel = channel;
            this.saslClient = saslClient;
        }

        @Override
        public CompletableFuture<byte[]> apply(byte[] challenge) {
            if (!this.saslClient.isComplete() && challenge != null) {
                byte[] response;
                try {
                    response = AuthHandler.this.evaluateChallenge(this.saslClient, challenge, AuthHandler.this.authentication.clientSubject());
                }
                catch (SaslException e) {
                    throw new HotRodClientException(e);
                }
                if (response != null) {
                    AuthOperation op = new AuthOperation(AuthHandler.this.authentication.saslMechanism(), response);
                    OperationChannel operationChannel = (OperationChannel)this.channel.attr(OperationChannel.OPERATION_CHANNEL_ATTRIBUTE_KEY).get();
                    operationChannel.forceSendOperation(op);
                    return op.thenCompose((Function)this);
                }
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

