/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.completers;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.aesh.command.Command;
import org.infinispan.cli.Context;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.ContextAwareCompleterInvocation;
import org.infinispan.cli.completers.ListCompleter;
import org.infinispan.cli.connection.Connection;

public class SiteCompleter
extends ListCompleter {
    @Override
    protected Collection<String> getAvailableItems(ContextAwareCompleterInvocation invocation) throws IOException {
        Context context = invocation.context;
        Command cmd = invocation.getCommand();
        Connection connection = context.getConnection();
        Optional<String> cacheName = CacheCompleter.getCacheName(context, cmd);
        return cacheName.map(name -> SiteCompleter.getAvailableSites(connection, name)).orElseGet(connection::getSitesView);
    }

    @Override
    Collection<String> getAvailableItems(Context context) throws IOException {
        throw new IllegalStateException();
    }

    private static Collection<String> getAvailableSites(Connection connection, String cacheName) {
        try {
            return connection.getAvailableSites(connection.getActiveContainer().getName(), cacheName);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

