/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.gitlab4j.api.utils.SecretString;

public class Oauth2LoginStreamingOutput
implements StreamingOutput,
AutoCloseable {
    private final String username;
    private final SecretString password;

    public Oauth2LoginStreamingOutput(String username, CharSequence password) {
        this.username = username;
        this.password = new SecretString(password);
    }

    public Oauth2LoginStreamingOutput(String username, char[] password) {
        this.username = username;
        this.password = new SecretString(password);
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        writer.write("{ ");
        writer.write("\"grant_type\": \"password\", ");
        writer.write("\"username\": \"" + this.username + "\", ");
        writer.write("\"password\": ");
        ((Writer)writer).write(34);
        int length = this.password.length();
        for (int i = 0; i < length; ++i) {
            char c = this.password.charAt(i);
            if (c == '\"' || c == '\\') {
                ((Writer)writer).write(92);
            }
            ((Writer)writer).write(c);
        }
        ((Writer)writer).write(34);
        writer.write(" }");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void clearPassword() {
        this.password.clear();
    }

    @Override
    public void close() {
        this.clearPassword();
    }

    public void finalize() throws Throwable {
        this.clearPassword();
        super.finalize();
    }
}

