/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils.jackson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.util.Optional;
import org.dromara.easyes.common.utils.jackson.JacksonCustomConfig;

public class JacksonCustomAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static PropertyName getPropertyName(Annotated m) {
        String jsonName;
        AnnotatedField f;
        JacksonCustomConfig config;
        if (m instanceof AnnotatedField && (config = JacksonCustomConfig.jacksonConfigMap.get((f = (AnnotatedField)m).getDeclaringClass())) != null && (jsonName = config.javaJsonFieldNameMap.get(f.getName())) != null) {
            return new PropertyName(jsonName);
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated m) {
        return Optional.ofNullable(JacksonCustomAnnotationIntrospector.getPropertyName(m)).orElse(super.findNameForSerialization(m));
    }

    public PropertyName findNameForDeserialization(Annotated m) {
        return Optional.ofNullable(JacksonCustomAnnotationIntrospector.getPropertyName(m)).orElse(super.findNameForDeserialization(m));
    }

    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> c, Annotated a) {
        AnnotatedClass f;
        JacksonCustomConfig config;
        if (a instanceof AnnotatedClass && (config = JacksonCustomConfig.jacksonConfigMap.get((f = (AnnotatedClass)a).getAnnotated())) != null) {
            return config.allJsonField;
        }
        return super.findPropertyInclusionByName(c, a);
    }

    public JsonFormat.Value findFormat(Annotated a) {
        JsonFormat.Value value;
        AnnotatedMethod f;
        JacksonCustomConfig config;
        if (a instanceof AnnotatedMethod && (config = JacksonCustomConfig.jacksonConfigMap.get((f = (AnnotatedMethod)a).getDeclaringClass())) != null && (value = config.formatMap.get(f.getName())) != null) {
            return value;
        }
        return super.findFormat(a);
    }

    public JsonInclude.Value findPropertyInclusion(Annotated a) {
        JsonInclude.Value value;
        AnnotatedMember f;
        JacksonCustomConfig config;
        if (a instanceof AnnotatedMember && (config = JacksonCustomConfig.jacksonConfigMap.get((f = (AnnotatedMember)a).getDeclaringClass())) != null && (value = config.includeMap.get(f.getName())) != null) {
            return value;
        }
        return super.findPropertyInclusion(a);
    }
}

