/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.projection;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.ShorthandProjection;

public final class ProjectionsContext {
    private final int startIndex;
    private final int stopIndex;
    private final boolean distinctRow;
    private final Collection<Projection> projections;
    private final List<String> columnLabels;

    public boolean isUnqualifiedShorthandProjection() {
        if (1 != this.projections.size()) {
            return false;
        }
        Projection projection = this.projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    public Optional<String> findAlias(String projectionName) {
        for (Projection each : this.projections) {
            if (!projectionName.equalsIgnoreCase(each.getExpression())) continue;
            return each.getAlias();
        }
        return Optional.absent();
    }

    public Optional<Integer> findProjectionIndex(String projectionName) {
        int result = 1;
        for (Projection each : this.projections) {
            if (projectionName.equalsIgnoreCase(each.getExpression())) {
                return Optional.of((Object)result);
            }
            ++result;
        }
        return Optional.absent();
    }

    public List<AggregationProjection> getAggregationProjections() {
        LinkedList<AggregationProjection> result = new LinkedList<AggregationProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationProjection)) continue;
            AggregationProjection aggregationProjection = (AggregationProjection)each;
            result.add(aggregationProjection);
            result.addAll(aggregationProjection.getDerivedAggregationProjections());
        }
        return result;
    }

    public List<AggregationDistinctProjection> getAggregationDistinctProjections() {
        LinkedList<AggregationDistinctProjection> result = new LinkedList<AggregationDistinctProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationDistinctProjection)) continue;
            result.add((AggregationDistinctProjection)each);
        }
        return result;
    }

    @ConstructorProperties(value={"startIndex", "stopIndex", "distinctRow", "projections", "columnLabels"})
    public ProjectionsContext(int startIndex, int stopIndex, boolean distinctRow, Collection<Projection> projections, List<String> columnLabels) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.distinctRow = distinctRow;
        this.projections = projections;
        this.columnLabels = columnLabels;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public boolean isDistinctRow() {
        return this.distinctRow;
    }

    public Collection<Projection> getProjections() {
        return this.projections;
    }

    public List<String> getColumnLabels() {
        return this.columnLabels;
    }

    public String toString() {
        return "ProjectionsContext(startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", distinctRow=" + this.isDistinctRow() + ", projections=" + this.getProjections() + ", columnLabels=" + this.getColumnLabels() + ")";
    }
}

