/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine.LimitPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine.RowNumberPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.pagination.engine.TopPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.top.TopSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class PaginationContextEngine {
    public PaginationContext createPaginationContext(SelectStatement selectStatement, ProjectionsContext projectionsContext, List<Object> parameters) {
        Optional limitSegment = selectStatement.findSQLSegment(LimitSegment.class);
        if (limitSegment.isPresent()) {
            return new LimitPaginationContextEngine().createPaginationContext((LimitSegment)limitSegment.get(), parameters);
        }
        Optional topSegment = selectStatement.findSQLSegment(TopSegment.class);
        Optional whereSegment = selectStatement.findSQLSegment(WhereSegment.class);
        if (topSegment.isPresent()) {
            return new TopPaginationContextEngine().createPaginationContext((TopSegment)topSegment.get(), whereSegment.isPresent() ? ((WhereSegment)whereSegment.get()).getAndPredicates() : Collections.emptyList(), parameters);
        }
        if (whereSegment.isPresent()) {
            return new RowNumberPaginationContextEngine().createPaginationContext(((WhereSegment)whereSegment.get()).getAndPredicates(), projectionsContext, parameters);
        }
        return new PaginationContext(null, null, parameters);
    }
}

