/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.statement.dml;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.generic.TableSegmentAvailable;

public final class InsertStatement
extends DMLStatement
implements TableSegmentAvailable {
    private TableSegment table;
    private SetAssignmentsSegment setAssignment;
    private final Collection<ColumnSegment> columns = new LinkedList<ColumnSegment>();
    private final Collection<InsertValuesSegment> values = new LinkedList<InsertValuesSegment>();

    public Optional<SetAssignmentsSegment> getSetAssignment() {
        return Optional.fromNullable((Object)this.setAssignment);
    }

    public boolean useDefaultColumns() {
        return this.columns.isEmpty() && null == this.setAssignment;
    }

    public List<String> getColumnNames() {
        return null == this.setAssignment ? this.getColumnNamesForInsertColumns() : this.getColumnNamesForSetAssignment();
    }

    private List<String> getColumnNamesForInsertColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnSegment each : this.columns) {
            result.add(each.getName().toLowerCase());
        }
        return result;
    }

    private List<String> getColumnNamesForSetAssignment() {
        LinkedList<String> result = new LinkedList<String>();
        for (AssignmentSegment each : this.setAssignment.getAssignments()) {
            result.add(each.getColumn().getName().toLowerCase());
        }
        return result;
    }

    public int getValueListCount() {
        return null == this.setAssignment ? this.values.size() : 1;
    }

    public int getValueCountForPerGroup() {
        if (!this.values.isEmpty()) {
            return this.values.iterator().next().getValues().size();
        }
        if (null != this.setAssignment) {
            return this.setAssignment.getAssignments().size();
        }
        return 0;
    }

    public List<List<ExpressionSegment>> getAllValueExpressions() {
        return null == this.setAssignment ? this.getAllValueExpressionsFromValues() : Collections.singletonList(this.getAllValueExpressionsFromSetAssignment());
    }

    private List<List<ExpressionSegment>> getAllValueExpressionsFromValues() {
        ArrayList<List<ExpressionSegment>> result = new ArrayList<List<ExpressionSegment>>(this.values.size());
        for (InsertValuesSegment each : this.values) {
            result.add(each.getValues());
        }
        return result;
    }

    private List<ExpressionSegment> getAllValueExpressionsFromSetAssignment() {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(this.setAssignment.getAssignments().size());
        for (AssignmentSegment each : this.setAssignment.getAssignments()) {
            result.add(each.getValue());
        }
        return result;
    }

    @Override
    public TableSegment getTable() {
        return this.table;
    }

    public Collection<ColumnSegment> getColumns() {
        return this.columns;
    }

    public Collection<InsertValuesSegment> getValues() {
        return this.values;
    }

    @Override
    public void setTable(TableSegment table) {
        this.table = table;
    }

    public void setSetAssignment(SetAssignmentsSegment setAssignment) {
        this.setAssignment = setAssignment;
    }
}

