/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.item.impl;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ShorthandSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;

public final class ShorthandSelectItemExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ShorthandSelectItemSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> unqualifiedShorthandNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.UNQUALIFIED_SHORTHAND);
        if (unqualifiedShorthandNode.isPresent()) {
            return Optional.of((Object)new ShorthandSelectItemSegment(((ParserRuleContext)unqualifiedShorthandNode.get()).getStart().getStartIndex(), ((ParserRuleContext)unqualifiedShorthandNode.get()).getStop().getStopIndex(), ((ParserRuleContext)unqualifiedShorthandNode.get()).getText()));
        }
        Optional<ParserRuleContext> qualifiedShorthandNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.QUALIFIED_SHORTHAND);
        if (qualifiedShorthandNode.isPresent()) {
            ShorthandSelectItemSegment result = new ShorthandSelectItemSegment(((ParserRuleContext)qualifiedShorthandNode.get()).getStart().getStartIndex(), ((ParserRuleContext)qualifiedShorthandNode.get()).getStop().getStopIndex(), ((ParserRuleContext)qualifiedShorthandNode.get()).getText());
            ParserRuleContext ownerNode = (ParserRuleContext)((ParserRuleContext)qualifiedShorthandNode.get()).getChild(0);
            result.setOwner(new TableSegment(ownerNode.getStart().getStartIndex(), ownerNode.getStop().getStopIndex(), ownerNode.getText()));
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }
}

