/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.item.SelectItemExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemsSegment;

public final class SelectItemsExtractor
implements OptionalSQLSegmentExtractor {
    private final Collection<String> rowNumberIdentifiers;
    private final SelectItemExtractor selectItemExtractor = new SelectItemExtractor();

    public SelectItemsExtractor() {
        this.rowNumberIdentifiers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.rowNumberIdentifiers.add("rownum");
        this.rowNumberIdentifiers.add("ROW_NUMBER");
    }

    public Optional<SelectItemsSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        ParserRuleContext selectItemsNode = ExtractorUtils.getFirstChildNode(this.findMainQueryNode(ancestorNode), RuleName.SELECT_ITEMS);
        SelectItemsSegment result = new SelectItemsSegment(selectItemsNode.getStart().getStartIndex(), selectItemsNode.getStop().getStopIndex(), this.extractDistinct(ancestorNode));
        Optional<ParserRuleContext> unqualifiedShorthandNode = ExtractorUtils.findFirstChildNode(selectItemsNode, RuleName.UNQUALIFIED_SHORTHAND);
        if (unqualifiedShorthandNode.isPresent()) {
            this.setUnqualifiedShorthandSelectItemSegment((ParserRuleContext)unqualifiedShorthandNode.get(), result, parameterMarkerIndexes);
        }
        this.setSelectItemSegment(selectItemsNode, result, parameterMarkerIndexes);
        return Optional.of((Object)result);
    }

    private void setUnqualifiedShorthandSelectItemSegment(ParserRuleContext unqualifiedShorthandNode, SelectItemsSegment selectItemsSegment, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<? extends SelectItemSegment> unqualifiedShorthandSelectItemSegment = this.selectItemExtractor.extract(unqualifiedShorthandNode, parameterMarkerIndexes);
        if (unqualifiedShorthandSelectItemSegment.isPresent()) {
            selectItemsSegment.getSelectItems().add((SelectItemSegment)unqualifiedShorthandSelectItemSegment.get());
        }
    }

    private void setSelectItemSegment(ParserRuleContext selectItemsNode, SelectItemsSegment selectItemsSegment, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(selectItemsNode, RuleName.SELECT_ITEM)) {
            Optional<? extends SelectItemSegment> selectItemSegment = this.selectItemExtractor.extract(each, parameterMarkerIndexes);
            if (!selectItemSegment.isPresent()) continue;
            selectItemsSegment.getSelectItems().add((SelectItemSegment)selectItemSegment.get());
        }
    }

    private boolean extractDistinct(ParserRuleContext selectItemsNode) {
        Optional<ParserRuleContext> duplicateSpecificationNode = ExtractorUtils.findFirstChildNode(selectItemsNode, RuleName.DUPLICATE_SPECIFICATION);
        if (duplicateSpecificationNode.isPresent()) {
            String text = ((ParserRuleContext)duplicateSpecificationNode.get()).getText();
            return "DISTINCT".equalsIgnoreCase(text) || "DISTINCTROW".equalsIgnoreCase(text);
        }
        return false;
    }

    private ParserRuleContext findMainQueryNode(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> tableReferencesNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.TABLE_REFERENCES);
        if (!tableReferencesNode.isPresent()) {
            return ancestorNode;
        }
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findSingleNodeFromFirstDescendant((ParserRuleContext)tableReferencesNode.get(), RuleName.SUBQUERY);
        if (subqueryNode.isPresent()) {
            return this.findMainQueryNode((ParserRuleContext)subqueryNode.get());
        }
        return ancestorNode;
    }
}

