/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.api.SQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.parser.SQLAST;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;

public final class SQLSegmentsExtractorEngine {
    public Collection<SQLSegment> extract(SQLAST ast) {
        LinkedList<SQLSegment> result = new LinkedList<SQLSegment>();
        for (SQLSegmentExtractor each : ast.getSqlStatementRule().getExtractors()) {
            if (each instanceof OptionalSQLSegmentExtractor) {
                Optional<? extends SQLSegment> sqlSegment = ((OptionalSQLSegmentExtractor)each).extract(ast.getParserRuleContext(), ast.getParameterMarkerIndexes());
                if (!sqlSegment.isPresent()) continue;
                result.add((SQLSegment)sqlSegment.get());
                continue;
            }
            if (!(each instanceof CollectionSQLSegmentExtractor)) continue;
            result.addAll(((CollectionSQLSegmentExtractor)each).extract(ast.getParserRuleContext(), ast.getParameterMarkerIndexes()));
        }
        return result;
    }
}

