/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateKeyGeneratorException;
import org.apache.shardingsphere.infra.distsql.exception.rule.KeyGeneratorInUsedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredKeyGeneratorMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingKeyGeneratorStatement;

public final class DropShardingKeyGeneratorStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingKeyGeneratorStatement, ShardingRuleConfiguration> {
    private static final String TYPE = DropShardingKeyGeneratorStatement.class.getName();

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig && sqlStatement.isContainsExistClause()) {
            return;
        }
        String schemaName = shardingSphereMetaData.getName();
        LinkedList<String> keyGeneratorNames = new LinkedList<String>(sqlStatement.getKeyGeneratorNames());
        this.checkDuplicate(schemaName, keyGeneratorNames);
        this.checkExist(schemaName, keyGeneratorNames, currentRuleConfig, sqlStatement);
        this.checkInUsed(schemaName, keyGeneratorNames, currentRuleConfig);
    }

    private void checkDuplicate(String schemaName, Collection<String> keyGeneratorNames) throws DistSQLException {
        Collection duplicateNames = keyGeneratorNames.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)duplicateNames.isEmpty(), () -> new DuplicateKeyGeneratorException("sharding", schemaName, duplicateNames));
    }

    private void checkExist(String schemaName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig, DropShardingKeyGeneratorStatement sqlStatement) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        Collection notExistKeyGenerators = keyGeneratorNames.stream().filter(each -> !currentRuleConfig.getKeyGenerators().containsKey(each)).collect(Collectors.toCollection(LinkedList::new));
        DistSQLException.predictionThrow((boolean)notExistKeyGenerators.isEmpty(), () -> new RequiredKeyGeneratorMissedException("Sharding", schemaName, notExistKeyGenerators));
    }

    private void checkInUsed(String schemaName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection<String> usedKeyGenerators = this.getUsedKeyGenerators(currentRuleConfig);
        Collection inUsedNames = keyGeneratorNames.stream().filter(usedKeyGenerators::contains).collect(Collectors.toCollection(LinkedList::new));
        DistSQLException.predictionThrow((boolean)inUsedNames.isEmpty(), () -> new KeyGeneratorInUsedException("Sharding", schemaName, inUsedNames));
    }

    public boolean updateCurrentRuleConfiguration(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getKeyGenerators().keySet().removeIf(sqlStatement.getKeyGeneratorNames()::contains);
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return TYPE;
    }

    private Collection<String> getUsedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> Objects.nonNull(each.getKeyGenerateStrategy())).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = shardingRuleConfig.getDefaultKeyGenerateStrategy();
        if (Objects.nonNull(keyGenerateStrategy) && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getKeyGenerators().keySet(), sqlStatement.getKeyGeneratorNames()).isEmpty();
    }
}

